/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.client.models.IHasModel;
import com.teamacronymcoders.base.client.models.generator.IHasGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.items.IHasItemColor;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMaterialArmor
extends ItemArmor
implements IHasModel,
IHasItemColor,
IHasGeneratedModel {
    private MaterialPart materialPart;
    private IBaseMod mod;
    private NonNullList<ItemStack> repairList;

    public ItemMaterialArmor(MaterialPart materialPart, ItemArmor.ArmorMaterial material, EntityEquipmentSlot equipmentSlot) {
        super(material, 0, equipmentSlot);
        this.materialPart = materialPart;
        this.func_77655_b(materialPart.getMaterial().getUnlocalizedName() + "_" + equipmentSlot.func_188450_d().toLowerCase(Locale.US));
    }

    public boolean func_82816_b_(@Nonnull ItemStack stack) {
        return this.materialPart.isColorized();
    }

    public int func_82814_b(@Nonnull ItemStack stack) {
        return this.materialPart.getColor();
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack itemStack) {
        return I18n.func_74837_a((String)(this.materialPart.getPart().getUnlocalizedName() + "." + this.field_77881_a.func_188450_d()), (Object[])new Object[]{this.materialPart.getMaterial().getName()});
    }

    @Override
    public IBaseMod getMod() {
        return this.mod;
    }

    @Override
    public void setMod(IBaseMod mod) {
        this.mod = mod;
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public List<String> getModelNames(List<String> modelNames) {
        modelNames.add(this.materialPart.getMaterial().getUnlocalizedName() + "_" + this.field_77881_a.func_188450_d().toLowerCase(Locale.US));
        return modelNames;
    }

    @Override
    public List<IGeneratedModel> getGeneratedModels() {
        ArrayList models = Lists.newArrayList();
        TemplateFile templateFile = TemplateManager.getTemplateFile("item_model");
        HashMap replacements = Maps.newHashMap();
        replacements.put("texture", "base:items/" + this.field_77881_a.func_188450_d().toLowerCase(Locale.US));
        templateFile.replaceContents(replacements);
        models.add(new GeneratedModel(this.materialPart.getMaterial().getUnlocalizedName() + "_" + this.field_77881_a.func_188450_d().toLowerCase(Locale.US), ModelType.ITEM_MODEL, templateFile.getFileContents()));
        return models;
    }

    @Override
    public int getColorFromItemstack(@Nonnull ItemStack stack, int tintIndex) {
        return this.func_82814_b(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return String.format("%s:textures/models/armor/material_layer_%d%s.png", "base", this.isLegSlot(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
    }

    public boolean hasOverlay(@Nonnull ItemStack stack) {
        return true;
    }

    private boolean isLegSlot(EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.LEGS;
    }

    public boolean func_82789_a(ItemStack toRepair, @Nullable ItemStack repair) {
        return repair != null && this.getRepairItems().stream().anyMatch(repairItem -> ItemStack.func_179545_c((ItemStack)repair, (ItemStack)repairItem));
    }

    public NonNullList<ItemStack> getRepairItems() {
        if (this.repairList == null) {
            this.repairList = OreDictionary.getOres((String)this.getIngotName());
        }
        return this.repairList;
    }

    public String getIngotName() {
        return this.materialPart.getOreDictString().replace("armor", "ingot");
    }
}

