/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.blocks;

import com.google.common.collect.Maps;
import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.materialsystem.MaterialSystem;
import com.teamacronymcoders.base.materialsystem.MaterialUser;
import com.teamacronymcoders.base.materialsystem.blocks.SubBlockPart;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.partdata.DataPartParsers;
import com.teamacronymcoders.base.materialsystem.partdata.MaterialPartData;
import com.teamacronymcoders.base.materialsystem.parts.Part;
import com.teamacronymcoders.base.util.ItemStackUtils;
import com.teamacronymcoders.base.util.OreDictUtils;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SubBlockOreSamplePart
extends SubBlockPart {
    private ItemStack itemStackToDrop = null;
    private String itemDrop;
    private String activatedText;
    private IBaseMod mod;

    public SubBlockOreSamplePart(MaterialPart materialPart, MaterialUser materialUser) {
        super(materialPart, MaterialSystem.materialCreativeTab);
        MaterialPartData data = materialPart.getData();
        this.setHardness(data.getValue("hardness", Float.valueOf(0.125f), DataPartParsers::getFloat).floatValue());
        this.setResistance(data.getValue("resistance", 2, DataPartParsers::getInt));
        this.setHarvestLevel(data.getValue("harvestLevel", -1, DataPartParsers::getInt));
        this.setHarvestTool(data.getValue("harvestTool", null, DataPartParsers::getString));
        this.mod = materialUser.getMod();
        this.itemDrop = data.getValue("drops", this.itemDrop, DataPartParsers::getString);
        this.activatedText = data.getValue("activatedText", this.activatedText, DataPartParsers::getString);
    }

    @Override
    public Material getMaterial() {
        return Material.field_151578_c;
    }

    @Override
    public void getDrops(int fortune, List<ItemStack> itemStacks) {
        ItemStack itemStack = this.getItemStack().func_77946_l();
        if (ItemStackUtils.isValid(itemStack)) {
            itemStacks.add(itemStack);
        } else {
            this.mod.getLogger().fatal("Couldn't drop null ItemStack for " + this.getMaterialPart().getLocalizedName());
        }
    }

    @Override
    public ItemStack getItemStack() {
        if (this.itemStackToDrop == null) {
            if (this.itemDrop != null && !this.itemDrop.isEmpty()) {
                String[] itemDropArray = this.itemDrop.split(":");
                String itemString = itemDropArray[0];
                if (itemString.equalsIgnoreCase("oredict")) {
                    this.itemStackToDrop = OreDictUtils.getPreferredItemStack(itemDropArray[1]);
                } else {
                    Item item;
                    int meta = 0;
                    if (itemDropArray.length > 1) {
                        itemString = itemString + ":" + itemDropArray[1];
                        if (itemDropArray.length > 2) {
                            meta = Integer.parseInt(itemDropArray[2]);
                        }
                    }
                    if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString))) != null) {
                        this.itemStackToDrop = new ItemStack(item, 1, meta);
                    } else {
                        this.mod.getLogger().error("Could not find Item for name: " + itemString);
                    }
                }
            } else {
                this.itemStackToDrop = super.getItemStack();
            }
        }
        return this.itemStackToDrop;
    }

    @Override
    public IGeneratedModel getGeneratedModel() {
        TemplateFile templateFile = TemplateManager.getTemplateFile("ore_sample_block");
        HashMap replacements = Maps.newHashMap();
        Part part = this.getMaterialPart().getPart();
        replacements.put("texture", String.format("%s:blocks/%s", "minecraft", "gravel"));
        replacements.put("particle", String.format("%s:blocks/%s", "minecraft", "stone"));
        replacements.put("ore", String.format("%s:blocks/%s", part.getOwnerId(), part.getShortUnlocalizedName()));
        templateFile.replaceContents(replacements);
        return new GeneratedModel(this.getModelPrefix() + this.getUnLocalizedName(), ModelType.BLOCKSTATE, templateFile.getFileContents());
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isTopSolid() {
        return false;
    }

    @Override
    public BlockFaceShape getBlockFaceShape() {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 0.25, (double)0.8f);
    }

    @Override
    public boolean isFullCube() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean isPassable() {
        return true;
    }

    @Override
    public boolean isFullBlock() {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public boolean canSilkHarvest() {
        return false;
    }

    @Override
    public void onNeighborChange(World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            this.spawnItemStackEntity(world, this.getItemStack().func_77946_l(), pos);
            world.func_175698_g(pos);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, @Nonnull BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP);
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, EntityPlayer player) {
        if (this.activatedText != null && !this.activatedText.isEmpty()) {
            player.func_146105_b((ITextComponent)new TextComponentString(this.activatedText), true);
        } else {
            this.spawnItemStackEntity(world, this.getItemStack().func_77946_l(), pos);
        }
        world.func_175698_g(pos);
        player.func_184609_a(EnumHand.MAIN_HAND);
        return true;
    }
}

