/*
 * Decompiled with CFR 0.152.
 */
package ladylib.registration;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import ladylib.LadyLib;
import ladylib.client.ICustomLocation;
import ladylib.registration.AutoRegistryRef;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemRegistrar {
    private final LadyLib ladyLib;
    private Map<Item, ItemInfo> allItems = new HashMap<Item, ItemInfo>();

    public static <T extends Item> T name(T item, String name) {
        return (T)((Item)item.setRegistryName(name)).func_77655_b(item.getRegistryName().func_110624_b() + "." + name);
    }

    ItemRegistrar(LadyLib ladyLib) {
        this.ladyLib = ladyLib;
    }

    void addItem(@Nonnull Item item, AutoRegistryRef ref) {
        this.addItem(item, ref.isListed(), ref.getOreNames());
    }

    public void addItem(@Nonnull Item item, boolean listed, String ... oreNames) {
        Preconditions.checkNotNull((Object)item.getRegistryName(), (String)"Can't use a null-name for the registry, object %s.", (Object)item);
        this.allItems.put(item, new ItemInfo(listed, oreNames));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    void registerItems(RegistryEvent.Register<Item> event) {
        this.allItems.forEach((item, info) -> {
            event.getRegistry().register((IForgeRegistryEntry)item);
            if (info.listed) {
                item.func_77637_a(this.ladyLib.getCreativeTab());
            }
            for (String oreName : info.oreNames) {
                OreDictionary.registerOre((String)oreName, (Item)item);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    void registerRenders(ModelRegistryEvent event) {
        this.allItems.keySet().stream().filter(itemIn -> !(Block.func_149634_a((Item)itemIn) instanceof BlockFluidBase)).forEach(ItemRegistrar::registerRender);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRender(Item item) {
        if (item instanceof ICustomLocation) {
            ((ICustomLocation)item).registerRender();
        } else {
            ItemRegistrar.registerRender(item, new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()).toString()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRender(Item item, ModelResourceLocation loc) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)loc);
    }

    public Collection<Item> getAllItems() {
        return this.allItems.keySet();
    }

    public Stream<Item> getInvisibleItems() {
        return this.allItems.entrySet().stream().filter(entry -> !((ItemInfo)entry.getValue()).listed).map(Map.Entry::getKey);
    }

    class ItemInfo {
        boolean listed;
        String[] oreNames;

        ItemInfo(boolean listed, String[] oreNames) {
            this.listed = listed;
            this.oreNames = oreNames;
        }
    }
}

