/*
 * Decompiled with CFR 0.152.
 */
package ladylib.registration;

import ladylib.LadyLib;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import org.objectweb.asm.Type;

public class ClientRegistrar {
    static <T extends TileEntity> void registerTESR(Class<T> tileClass, Type tesrType) {
        if (tesrType == null) {
            return;
        }
        try {
            Class<?> tesrClass = Class.forName(tesrType.getClassName(), true, (ClassLoader)Loader.instance().getModClassLoader());
            if (tesrClass.equals(TileEntitySpecialRenderer.class)) {
                return;
            }
            TileEntitySpecialRenderer tesr = (TileEntitySpecialRenderer)tesrClass.newInstance();
            ClientRegistry.bindTileEntitySpecialRenderer(tileClass, (TileEntitySpecialRenderer)tesr);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LadyLib.LOGGER.error("Error while registering a TESR", (Throwable)e);
        }
    }
}

