/*
 * Decompiled with CFR 0.152.
 */
package ladylib.registration;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import ladylib.LadyLib;
import ladylib.registration.AutoRegistryRef;
import ladylib.registration.ItemRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockRegistrar {
    private final LadyLib ladyLib;
    private ItemRegistrar itemRegistrar;
    private Map<Block, BlockInfo> allBlocks = new HashMap<Block, BlockInfo>();

    @Nonnull
    public static <T extends Block> T name(@Nonnull T block, @Nonnull String name) {
        return (T)((Block)block.setRegistryName(name)).func_149663_c(block.getRegistryName().func_110624_b() + "." + name);
    }

    BlockRegistrar(LadyLib ladyLib, ItemRegistrar itemRegistrar) {
        this.ladyLib = ladyLib;
        this.itemRegistrar = itemRegistrar;
    }

    void addBlock(Block block, AutoRegistryRef ref) {
        this.addBlock(block, ref.isListed(), ref.isMakeItemBlock(), ref.getOreNames());
    }

    public void addBlock(@Nonnull Block block, boolean listed, boolean makeItemBlock, String ... oreNames) {
        Function<Block, Item> itemGen = makeItemBlock ? b -> (Item)new ItemBlock(b).setRegistryName(Objects.requireNonNull(b.getRegistryName())) : b -> Items.field_190931_a;
        this.addBlock(block, itemGen, listed, oreNames);
    }

    public <T extends Item> T addBlock(@Nonnull Block block, @Nonnull Function<Block, T> blockItemFunction, boolean listed, String ... oreNames) {
        Item item;
        this.allBlocks.put(block, new BlockInfo(oreNames));
        if (listed) {
            block.func_149647_a(this.ladyLib.getCreativeTab());
        }
        if ((item = (Item)blockItemFunction.apply(block)) != null && item != Items.field_190931_a) {
            this.itemRegistrar.addItem(item, listed, new String[0]);
        }
        return (T)item;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    void registerBlocks(RegistryEvent.Register<Block> event) {
        this.allBlocks.forEach((block, info) -> {
            event.getRegistry().register((IForgeRegistryEntry)block);
            for (String oreName : info.oreNames) {
                OreDictionary.registerOre((String)oreName, (Block)block);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSmartRender(@Nonnull Block block, final @Nonnull ModelResourceLocation rl) {
        StateMapperBase ignoreState = new StateMapperBase(){

            @Nonnull
            protected ModelResourceLocation func_178132_a(@Nonnull IBlockState iBlockState) {
                return rl;
            }
        };
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)ignoreState);
    }

    public Set<Block> getAllBlocks() {
        return this.allBlocks.keySet();
    }

    class BlockInfo {
        @Nonnull
        String[] oreNames;

        public BlockInfo(String[] oreNames) {
            this.oreNames = oreNames;
        }
    }
}

