/*
 * Decompiled with CFR 0.152.
 */
package ladylib.registration;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import ladylib.LadyLib;
import ladylib.registration.AutoRegister;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

abstract class AutoRegistryRef<T extends AnnotatedElement> {
    protected static final LoadingCache<Class<?>, Optional<MethodHandle>> UNLOCALIZED_NAMES_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(type -> {
        if (type == null) {
            return Optional.empty();
        }
        try {
            Method m = Item.class.isAssignableFrom((Class<?>)type) ? ReflectionHelper.findMethod(Item.class, (String)"setUnlocalizedName", (String)"func_77655_b", (Class[])new Class[]{String.class}) : (Block.class.isAssignableFrom((Class<?>)type) ? ReflectionHelper.findMethod(Block.class, (String)"setUnlocalizedName", (String)"func_149663_c", (Class[])new Class[]{String.class}) : type.getMethod("setUnlocalizedName", String.class));
            if (m != null) {
                return Optional.of(MethodHandles.lookup().unreflect(m));
            }
        }
        catch (NoSuchMethodException m) {
        }
        catch (IllegalAccessException e) {
            LadyLib.LOGGER.error("Error while getting a getUnlocalizedName handle", (Throwable)e);
        }
        return Optional.empty();
    }));
    protected T referenced;
    protected String modId;
    private boolean listed;
    private boolean makeItemBlock;
    private String[] oldNames;
    private String[] oreNames;

    AutoRegistryRef(String modId, T referenced) {
        this.modId = modId;
        this.referenced = referenced;
        this.listed = !referenced.isAnnotationPresent(AutoRegister.Unlisted.class);
        this.makeItemBlock = !referenced.isAnnotationPresent(AutoRegister.NoItem.class);
        this.oldNames = referenced.isAnnotationPresent(AutoRegister.OldNames.class) ? referenced.getAnnotation(AutoRegister.OldNames.class).value() : new String[]{};
        this.oreNames = referenced.isAnnotationPresent(AutoRegister.Ore.class) ? referenced.getAnnotation(AutoRegister.Ore.class).value() : new String[]{};
    }

    boolean isListed() {
        return this.listed;
    }

    String[] getOldNames() {
        return this.oldNames;
    }

    String[] getOreNames() {
        return this.oreNames;
    }

    String getModId() {
        return this.modId;
    }

    boolean isMakeItemBlock() {
        return this.makeItemBlock;
    }

    abstract boolean isValidForRegistry(IForgeRegistry<?> var1);

    abstract <V extends IForgeRegistryEntry> V nameAndGet();
}

