/*
 * Decompiled with CFR 0.152.
 */
package ladylib;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import ladylib.client.ClientHandler;
import ladylib.client.IClientHandler;
import ladylib.client.particle.ParticleManager;
import ladylib.registration.AutoRegistrar;
import ladylib.registration.BlockRegistrar;
import ladylib.registration.ItemRegistrar;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LadyLib {
    public static Logger LOGGER = LogManager.getLogger((String)"LadyLib");
    private static final Map<String, LadyLib> allInstances = new HashMap<String, LadyLib>();
    private ModContainer owner;
    private String ownerModId;
    private CreativeTabs creativeTab;
    private AutoRegistrar registrar;
    private File configFolder;
    @SideOnly(value=Side.CLIENT)
    private ClientHandler clientHandler;

    public static LadyLib initLib(FMLPreInitializationEvent event) {
        LadyLib ret = new LadyLib();
        ret.preInit(event);
        allInstances.put(ret.ownerModId, ret);
        return ret;
    }

    public static boolean isDevEnv() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public static Collection<LadyLib> getAllInstances() {
        return allInstances.values();
    }

    private LadyLib() {
    }

    private void preInit(@Nonnull FMLPreInitializationEvent event) {
        this.owner = Loader.instance().activeModContainer();
        if (this.owner == null) {
            throw new IllegalStateException("LadyLib initialization was done at the wrong time");
        }
        this.ownerModId = this.owner.getModId();
        LOGGER = LogManager.getLogger((String)(this.owner.getName() + ":lib"));
        this.registrar = new AutoRegistrar(this, event.getAsmData());
        MinecraftForge.EVENT_BUS.register((Object)this.registrar);
        MinecraftForge.EVENT_BUS.register((Object)this.registrar.getItemRegistrar());
        MinecraftForge.EVENT_BUS.register((Object)this.registrar.getBlockRegistrar());
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.clientHandler = new ClientHandler();
            this.clientHandler.clientInit();
        }
        this.registrar.autoRegisterTileEntities(this, event.getAsmData());
        this.configFolder = event.getModConfigurationDirectory();
    }

    public CreativeTabs makeCreativeTab(final Supplier<ItemStack> icon) {
        CreativeTabs ret = new CreativeTabs(this.owner.getName()){

            @Nonnull
            public ItemStack func_78016_d() {
                return (ItemStack)icon.get();
            }
        };
        this.setCreativeTab(ret);
        return ret;
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    public void setCreativeTab(CreativeTabs tab) {
        this.creativeTab = tab;
    }

    public CreativeTabs getCreativeTab() {
        return this.creativeTab;
    }

    @Nonnull
    public ItemRegistrar getItemRegistrar() {
        return this.registrar.getItemRegistrar();
    }

    @Nonnull
    public BlockRegistrar getBlockRegistrar() {
        return this.registrar.getBlockRegistrar();
    }

    @Nonnull
    public String getModId() {
        return Objects.requireNonNull(this.ownerModId, "The enclosing mod's id was not set before calling the library");
    }

    @SideOnly(value=Side.CLIENT)
    public IClientHandler getClientHandler() {
        return this.clientHandler;
    }

    @SideOnly(value=Side.CLIENT)
    public ParticleManager getParticleManager() {
        return this.clientHandler.getParticleManager();
    }
}

