/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.util;

import java.util.Stack;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import net.gegy1000.psf.server.util.PointUtils;
import net.minecraft.util.math.AxisAlignedBB;

public class Matrix {
    private final Stack<Matrix4d> pool = new Stack();
    private final Stack<Matrix4d> matrices = new Stack();
    private final Matrix4d matrix = new Matrix4d();

    public Matrix(int initPoolSize) {
        for (int i = 0; i < initPoolSize; ++i) {
            this.pool.push(new Matrix4d());
        }
    }

    public void identity() {
        while (!this.matrices.empty()) {
            this.pool.push(this.matrices.pop());
        }
        this.matrix.setIdentity();
    }

    public void translate(double x, double y, double z) {
        Matrix4d matrix = this.matrices.push(this.takePool());
        matrix.set(new Vector3d(x, y, z));
        this.updateMatrix();
    }

    public void rotate(double angle, double x, double y, double z) {
        Matrix4d matrix = this.matrices.push(this.takePool());
        Quat4d rotation = new Quat4d();
        rotation.set(new AxisAngle4d(x, y, z, Math.toRadians(angle)));
        matrix.setRotation(rotation);
        this.updateMatrix();
    }

    public Point3d transform(Point3d point) {
        this.matrix.transform(point);
        return point;
    }

    public Point3d transform(double x, double y, double z) {
        return this.transform(new Point3d(x, y, z));
    }

    public AxisAlignedBB transform(AxisAlignedBB bounds) {
        Point3d[] transformedPoints = new Point3d[]{this.transform(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c), this.transform(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f), this.transform(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c), this.transform(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f), this.transform(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c), this.transform(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f), this.transform(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c), this.transform(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f)};
        Point3d min = PointUtils.min(transformedPoints);
        Point3d max = PointUtils.max(transformedPoints);
        return new AxisAlignedBB(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    private Matrix4d takePool() {
        if (this.pool.isEmpty()) {
            return new Matrix4d();
        }
        Matrix4d pop = this.pool.pop();
        pop.setIdentity();
        return pop;
    }

    private void updateMatrix() {
        this.matrix.setIdentity();
        for (Matrix4d matrix : this.matrices) {
            this.matrix.mul(matrix);
        }
    }
}

