/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.util;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

@ParametersAreNonnullByDefault
public class ContiguousBlockIterator
implements Iterator<BlockPos> {
    private final BlockPos origin;
    private final int range;
    private final Predicate<BlockPos> predicate;
    private final Set<BlockPos> seen;
    private final Queue<Node> search;

    public ContiguousBlockIterator(BlockPos origin, int range, Predicate<BlockPos> predicate) {
        this.origin = origin;
        this.range = range;
        this.seen = Sets.newHashSet((Object[])new BlockPos[]{origin});
        this.predicate = predicate;
        this.search = new ArrayDeque<Node>();
        this.search.add(new Node(origin, 0));
    }

    @Override
    public boolean hasNext() {
        return !this.search.isEmpty();
    }

    @Override
    public BlockPos next() {
        Node ret = this.search.poll();
        if (ret.getDistance() < this.range) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                BlockPos bp = ret.getPos().func_177972_a(face);
                if (!this.seen.contains(bp) && this.predicate.test(bp)) {
                    this.search.offer(new Node(bp, ret.getDistance() + 1));
                }
                this.seen.add(bp);
            }
        }
        return ret.getPos();
    }

    private static final class Node {
        private final BlockPos pos;
        private final int distance;

        public Node(BlockPos pos, int distance) {
            this.pos = pos;
            this.distance = distance;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getDistance() {
            return this.distance;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            return this.getDistance() == other.getDistance();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            result = result * 59 + this.getDistance();
            return result;
        }

        public String toString() {
            return "ContiguousBlockIterator.Node(pos=" + this.getPos() + ", distance=" + this.getDistance() + ")";
        }
    }
}

