/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.satellite;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.api.IUnique;

public class UniqueManager<T extends IUnique> {
    private Cache<UUID, T> satelliteCache = CacheBuilder.newBuilder().weakValues().removalListener(this::onRemoved).build();
    private List<Consumer<T>> addCallbacks = new ArrayList<Consumer<T>>();
    private List<Consumer<T>> removeCallbacks = new ArrayList<Consumer<T>>();

    public void register(@Nonnull T obj) {
        this.satelliteCache.put((Object)obj.getId(), obj);
        for (Consumer<T> c : this.addCallbacks) {
            c.accept(obj);
        }
    }

    public void remove(@Nonnull T obj) {
        this.remove(obj.getId());
    }

    public void remove(@Nonnull UUID id) {
        this.satelliteCache.invalidate((Object)id);
    }

    @Nullable
    public T get(@Nonnull UUID id) {
        return (T)((IUnique)this.satelliteCache.getIfPresent((Object)id));
    }

    public Collection<T> getAll() {
        return this.satelliteCache.asMap().values().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void onAdd(Consumer<T> callback) {
        this.addCallbacks.add(callback);
    }

    public void onRemove(Consumer<T> callback) {
        this.removeCallbacks.add(callback);
    }

    private void onRemoved(RemovalNotification<UUID, T> notif) {
        for (Consumer<Object> consumer : this.removeCallbacks) {
            consumer.accept(notif.getValue());
        }
    }

    public void flush() {
        this.satelliteCache.invalidateAll();
    }
}

