/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.satellite;

import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.gegy1000.psf.api.IController;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.server.block.controller.TileController;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.block.remote.tile.TileListedSpacecraft;
import net.gegy1000.psf.server.capability.CapabilityController;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftBlockAccess;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftBuilder;
import net.gegy1000.psf.server.satellite.AbstractSatellite;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileBoundSatellite
extends AbstractSatellite {
    private final TileController controller;
    private UUID id = UUID.randomUUID();
    @Nonnull
    private String name = "";

    @Override
    public IController getController() {
        return this.controller.getCapability(CapabilityController.INSTANCE, null);
    }

    @Override
    public Collection<IModule> getModules() {
        return this.controller.getModules().values().stream().map(TileController.ScanValue::getModule).collect(Collectors.toList());
    }

    @Override
    public BlockPos getPosition() {
        return this.controller.func_174877_v();
    }

    @Override
    public SpacecraftBlockAccess buildBlockAccess(World world) {
        BlockPos origin = this.controller.func_174877_v();
        SpacecraftBuilder builder = new SpacecraftBuilder();
        builder.copyFrom(world, origin, this.controller.getModules().keySet());
        return builder.buildBlockAccess(origin, world);
    }

    @Override
    public IListedSpacecraft toListedCraft() {
        return new TileListedSpacecraft(this);
    }

    @Override
    public World getWorld() {
        return this.controller.func_145831_w();
    }

    @Override
    public String getName() {
        return this.name.isEmpty() ? super.getName() : this.name;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74772_a("uuid_msb", this.getId().getMostSignificantBits());
        tag.func_74772_a("uuid_lsb", this.getId().getLeastSignificantBits());
        tag.func_74778_a("name", this.name);
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.id = new UUID(tag.func_74763_f("uuid_msb"), tag.func_74763_f("uuid_lsb"));
        this.name = tag.func_74779_i("name");
    }

    public TileBoundSatellite(TileController controller) {
        this.controller = controller;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setName(@Nonnull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }
}

