/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.satellite;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.client.IVisualReceiver;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketModule
implements IMessage {
    @Nonnull
    private UUID id;
    @Nonnull
    private NBTTagCompound tag;

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public PacketModule() {
    }

    public PacketModule(@Nonnull UUID id, @Nonnull NBTTagCompound tag) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (tag == null) {
            throw new NullPointerException("tag");
        }
        this.id = id;
        this.tag = tag;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    @Nonnull
    protected NBTTagCompound getTag() {
        return this.tag;
    }

    public static class Handler
    implements IMessageHandler<PacketModule, IMessage> {
        public IMessage onMessage(PacketModule message, MessageContext ctx) {
            PracticalSpaceFireworks.PROXY.handlePacket(ctx, player -> this.updateModuleClient(message));
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void updateModuleClient(PacketModule message) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui instanceof IVisualReceiver) {
                ((IVisualReceiver)gui).updateModule(message.getId(), message.getTag());
            }
        }
    }
}

