/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.satellite;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.gegy1000.psf.api.IController;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.block.remote.orbiting.OrbitingListedSpacecraft;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftBlockAccess;
import net.gegy1000.psf.server.satellite.AbstractSatellite;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OrbitingSatellite
extends AbstractSatellite {
    private final World world;
    private String name;
    private final UUID uuid;
    private final BlockPos position;
    private final SpacecraftBlockAccess blockAccess;
    private final IController controller;
    private final List<IModule> modules;

    public OrbitingSatellite(World world, String name, UUID uuid, BlockPos position, SpacecraftBlockAccess blockAccess, Collection<EntityPlayerMP> trackingPlayers) {
        this.world = world;
        this.name = name;
        this.uuid = uuid;
        this.position = position;
        this.blockAccess = blockAccess;
        this.controller = blockAccess.findController();
        this.modules = blockAccess.findModules();
        trackingPlayers.forEach(this::track);
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public IController getController() {
        return this.controller;
    }

    @Override
    public Collection<IModule> getModules() {
        return this.modules;
    }

    @Override
    public BlockPos getPosition() {
        return this.position;
    }

    @Override
    public SpacecraftBlockAccess buildBlockAccess(World world) {
        return this.blockAccess;
    }

    @Override
    public IListedSpacecraft toListedCraft() {
        return new OrbitingListedSpacecraft(this.name, this.position, this.uuid);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean isOrbiting() {
        return true;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("name", this.name);
        compound.func_186854_a("uuid", this.uuid);
        compound.func_74768_a("x", this.position.func_177958_n());
        compound.func_74768_a("y", this.position.func_177956_o());
        compound.func_74768_a("z", this.position.func_177952_p());
        compound.func_74782_a("block_data", (NBTBase)this.blockAccess.serialize(new NBTTagCompound()));
        return compound;
    }

    public static OrbitingSatellite deserialize(World world, NBTTagCompound compound) {
        String name = compound.func_74779_i("name");
        UUID uuid = compound.func_186857_a("uuid");
        BlockPos pos = new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
        SpacecraftBlockAccess blockAccess = SpacecraftBlockAccess.deserialize(compound.func_74775_l("block_data"));
        return new OrbitingSatellite(world, name, uuid, pos, blockAccess, Collections.emptyList());
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ISatellite && ((ISatellite)obj).getId().equals(this.uuid);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

