/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.satellite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.api.IController;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.server.block.PSFBlockRegistry;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.block.remote.entity.EntityListedSpacecraft;
import net.gegy1000.psf.server.entity.spacecraft.EntitySpacecraft;
import net.gegy1000.psf.server.entity.spacecraft.PacketLaunchCraft;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftBlockAccess;
import net.gegy1000.psf.server.network.PSFNetworkHandler;
import net.gegy1000.psf.server.satellite.AbstractSatellite;
import net.gegy1000.psf.server.satellite.OrbitingSatellite;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityBoundSatellite
extends AbstractSatellite {
    private final EntitySpacecraft spacecraft;
    private UUID uuid;
    private final List<IModule> modules = new ArrayList<IModule>();
    private IController controller;
    @Nonnull
    private String name = "";

    public EntityBoundSatellite(EntitySpacecraft spacecraft, UUID uuid) {
        this.spacecraft = spacecraft;
        this.uuid = uuid;
    }

    public void detectModules() {
        SpacecraftBlockAccess blockAccess = this.spacecraft.getBlockAccess();
        this.modules.clear();
        this.modules.addAll(blockAccess.findModules());
        this.controller = blockAccess.findController();
    }

    @Override
    public String getName() {
        return this.name.isEmpty() ? super.getName() : this.name;
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public IController getController() {
        return this.controller;
    }

    @Override
    public Collection<IModule> getModules() {
        return this.modules;
    }

    @Override
    public BlockPos getPosition() {
        return this.spacecraft.func_180425_c();
    }

    @Override
    public SpacecraftBlockAccess buildBlockAccess(World world) {
        return this.spacecraft.getBlockAccess();
    }

    @Override
    public IListedSpacecraft toListedCraft() {
        return new EntityListedSpacecraft(this.spacecraft, this.uuid);
    }

    @Override
    public World getWorld() {
        return this.spacecraft.func_130014_f_();
    }

    @Override
    public boolean canLaunch() {
        return true;
    }

    @Override
    public void launch() {
        PSFNetworkHandler.network.sendToServer((IMessage)new PacketLaunchCraft(this.spacecraft.func_145782_y()));
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ISatellite && ((ISatellite)obj).getId().equals(this.getId());
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74778_a("name", this.name);
        tag.func_186854_a("uuid", this.uuid);
        return tag;
    }

    @Override
    public void deserializeNBT(@Nullable NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag != null) {
            this.name = tag.func_74779_i("name");
            this.uuid = tag.func_186857_a("uuid");
        }
    }

    public ISatellite toOrbiting() {
        SpacecraftBlockAccess blockAccess = this.spacecraft.getBlockAccess();
        SpacecraftBlockAccess[] split = blockAccess.splitVertically(this.getWorld(), PSFBlockRegistry.payloadSeparator);
        SpacecraftBlockAccess topPart = split[split.length - 1];
        return new OrbitingSatellite(this.getWorld(), this.name, this.getId(), this.getPosition(), topPart, this.getTrackingPlayers());
    }

    @Override
    public void setName(@Nonnull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }
}

