/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.satellite;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.server.network.PSFNetworkHandler;
import net.gegy1000.psf.server.satellite.PacketModule;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class AbstractSatellite
implements ISatellite {
    private Map<UUID, EntityPlayerMP> trackingPlayers = new HashMap<UUID, EntityPlayerMP>();

    @Override
    public void sendModulePacket(IModule module, NBTTagCompound data) {
        for (EntityPlayerMP player : this.getTrackingPlayers()) {
            PSFNetworkHandler.network.sendTo((IMessage)new PacketModule(module.getId(), data), player);
        }
    }

    @Override
    @Nonnull
    public Collection<EntityPlayerMP> getTrackingPlayers() {
        return this.trackingPlayers.values();
    }

    @Override
    public void track(EntityPlayerMP player) {
        this.trackingPlayers.put(player.func_110124_au(), player);
    }

    @Override
    public void untrack(EntityPlayerMP player) {
        this.trackingPlayers.remove(player.func_110124_au());
    }
}

