/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.api.data.IScannedChunk;
import net.gegy1000.psf.api.data.ITerrainScan;
import net.minecraft.block.material.MapColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;

public class TerrainScanData
implements ITerrainScan {
    private final Map<ChunkPos, IScannedChunk> scannedChunks = new HashMap<ChunkPos, IScannedChunk>();
    private int minHeight;
    private int maxHeight;

    public void addChunk(ChunkData chunkData) {
        this.scannedChunks.put(chunkData.chunkPos, chunkData);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList chunkList = new NBTTagList();
        for (IScannedChunk scannedChunk : this.scannedChunks.values()) {
            chunkList.func_74742_a(scannedChunk.serializeNBT());
        }
        compound.func_74782_a("chunks", (NBTBase)chunkList);
        compound.func_74777_a("min_height", (short)this.minHeight);
        compound.func_74777_a("max_height", (short)this.maxHeight);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        NBTTagList chunkList = compound.func_150295_c("chunks", 10);
        for (int i = 0; i < chunkList.func_74745_c(); ++i) {
            ChunkData chunk = new ChunkData();
            chunk.deserializeNBT(chunkList.func_150305_b(i));
            this.scannedChunks.put(chunk.chunkPos, chunk);
        }
        this.minHeight = compound.func_74765_d("min_height");
        this.maxHeight = compound.func_74765_d("max_height");
    }

    @Override
    @Nullable
    public MapColor getMapColor(int x, int y, int z) {
        ChunkPos chunkPos = new ChunkPos(x >> 4, z >> 4);
        IScannedChunk scannedChunk = this.scannedChunks.get(chunkPos);
        if (scannedChunk != null) {
            return scannedChunk.getMapColor(x & 0xF, y & 0xFF, z & 0xF);
        }
        return null;
    }

    @Override
    @Nonnull
    public Collection<IScannedChunk> getChunks() {
        return this.scannedChunks.values();
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public static class ChunkData
    implements IScannedChunk {
        private ChunkPos chunkPos;
        private byte[] blockColors;

        @Override
        @Nonnull
        public ChunkPos getChunkPos() {
            return this.chunkPos;
        }

        @Override
        @Nullable
        public MapColor getMapColor(int x, int y, int z) {
            int idx = this.blockColors[x << 12 | z << 8 | y] & 0xFF;
            if (idx == 0) {
                return null;
            }
            return MapColor.field_76281_a[idx];
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("chunk_x", this.chunkPos.field_77276_a);
            compound.func_74768_a("chunk_z", this.chunkPos.field_77275_b);
            compound.func_74773_a("block_data", this.blockColors);
            return compound;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            this.chunkPos = new ChunkPos(compound.func_74762_e("chunk_x"), compound.func_74762_e("chunk_z"));
            this.blockColors = compound.func_74770_j("block_data");
        }

        public ChunkData() {
        }

        public ChunkData(ChunkPos chunkPos, byte[] blockColors) {
            this.chunkPos = chunkPos;
            this.blockColors = blockColors;
        }
    }
}

