/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules.data;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.api.data.IScannedChunk;
import net.gegy1000.psf.api.data.ITerrainScan;
import net.minecraft.block.material.MapColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;

public class EmptyTerrainScan
implements ITerrainScan {
    private final int scanRange;

    @Override
    @Nullable
    public MapColor getMapColor(int x, int y, int z) {
        return null;
    }

    @Override
    @Nonnull
    public Collection<IScannedChunk> getChunks() {
        ArrayList<IScannedChunk> scannedChunks = new ArrayList<IScannedChunk>();
        for (int localZ = -this.scanRange; localZ <= this.scanRange; ++localZ) {
            for (int localX = -this.scanRange; localX <= this.scanRange; ++localX) {
                scannedChunks.add(new EmptyChunk(new ChunkPos(localX, localZ)));
            }
        }
        return scannedChunks;
    }

    @Override
    public int getMinHeight() {
        return 62;
    }

    @Override
    public int getMaxHeight() {
        return 62;
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public EmptyTerrainScan(int scanRange) {
        this.scanRange = scanRange;
    }

    private class EmptyChunk
    implements IScannedChunk {
        private final ChunkPos pos;

        @Override
        @Nonnull
        public ChunkPos getChunkPos() {
            return this.pos;
        }

        @Override
        @Nullable
        public MapColor getMapColor(int x, int y, int z) {
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return new NBTTagCompound();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
        }

        public EmptyChunk(ChunkPos pos) {
            this.pos = pos;
        }
    }
}

