/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules.configs;

import com.google.common.base.Strings;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.gegy1000.psf.api.IModuleConfig;
import net.gegy1000.psf.server.modules.configs.AbstractConfig;
import net.minecraft.nbt.NBTTagCompound;

@ParametersAreNonnullByDefault
public class ConfigBasicToggle
extends AbstractConfig {
    private final String[] states;
    private int state;

    public ConfigBasicToggle(String key, String ... states) {
        super(key);
        this.states = states;
    }

    @Override
    public String getValue() {
        return Strings.nullToEmpty((String)this.states[this.state]);
    }

    @Override
    public void modified(@Nullable Object newValue) {
        this.state = (this.state + 1) % this.states.length;
    }

    @Override
    public IModuleConfig.ConfigType getType() {
        return IModuleConfig.ConfigType.TOGGLE;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("state", this.state);
        return tag;
    }

    @Override
    public void deserializeNBT(@Nullable NBTTagCompound tag) {
        if (tag != null) {
            this.state = tag.func_74762_e("state");
        }
    }

    protected int getState() {
        return this.state;
    }
}

