/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules;

import javax.annotation.Nonnull;
import net.gegy1000.psf.api.IModuleFactory;
import net.gegy1000.psf.server.modules.EmptyModule;
import net.gegy1000.psf.server.modules.ModuleBattery;
import net.gegy1000.psf.server.modules.ModuleController;
import net.gegy1000.psf.server.modules.ModuleEntityDetector;
import net.gegy1000.psf.server.modules.ModuleEntityMarker;
import net.gegy1000.psf.server.modules.ModuleFuelTank;
import net.gegy1000.psf.server.modules.ModuleSolarPanel;
import net.gegy1000.psf.server.modules.ModuleSpaceLaser;
import net.gegy1000.psf.server.modules.ModuleTerrainScanner;
import net.gegy1000.psf.server.modules.ModuleThruster;
import net.gegy1000.psf.server.modules.SimpleModuleFactory;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="psf")
public class Modules {
    private static IForgeRegistry<IModuleFactory> registry;

    @SubscribeEvent
    public static void createRegistry(RegistryEvent.NewRegistry event) {
        registry = new RegistryBuilder().setName(new ResourceLocation("psf", "modules")).setType(IModuleFactory.class).create();
    }

    @SubscribeEvent
    public static void registerModules(RegistryEvent.Register<IModuleFactory> event) {
        registry.register(new SimpleModuleFactory(ModuleController::new).setRegistryName("controller_simple"));
        registry.register(new SimpleModuleFactory(() -> new EmptyModule("strut")).setRegistryName("strut"));
        registry.register(new SimpleModuleFactory(() -> new ModuleBattery(ModuleBattery.BatteryTier.SIMPLE, 100000)).setRegistryName("battery_simple"));
        registry.register(new SimpleModuleFactory(() -> new ModuleThruster(ModuleThruster.ThrusterTier.SIMPLE)).setRegistryName("thruster_simple"));
        registry.register(new SimpleModuleFactory(() -> new ModuleEntityDetector(ModuleEntityDetector.EntityDetectorTier.SIMPLE)).setRegistryName("entity_detector_simple"));
        registry.register(new SimpleModuleFactory(ModuleEntityMarker::new).setRegistryName("entity_marker"));
        registry.register(new SimpleModuleFactory(ModuleFuelTank::new).setRegistryName("fuel_tank"));
        registry.register(new SimpleModuleFactory(() -> new EmptyModule("payload_separator")).setRegistryName("payload_separator"));
        registry.register(new SimpleModuleFactory(ModuleTerrainScanner::new).setRegistryName("terrain_scanner"));
        registry.register(new SimpleModuleFactory(() -> new ModuleSolarPanel()).setRegistryName("solar_panel"));
        registry.register(new SimpleModuleFactory(() -> new ModuleSpaceLaser()).setRegistryName("laser"));
    }

    @Nonnull
    public static IForgeRegistry<IModuleFactory> get() {
        IForgeRegistry<IModuleFactory> r = registry;
        if (r != null) {
            return r;
        }
        throw new IllegalStateException("Accessing module registry too early!");
    }
}

