/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules;

import net.gegy1000.psf.server.modules.EmptyModule;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;

public class ModuleThruster
extends EmptyModule {
    private ThrusterTier tier;

    public ModuleThruster(ThrusterTier tier) {
        super("thruster." + tier.func_176610_l());
        this.tier = tier;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74774_a("tier", (byte)(this.tier.ordinal() & 0xFF));
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        int tier = nbt.func_74771_c("tier") & 0xFF;
        this.tier = ThrusterTier.values()[tier % ThrusterTier.values().length];
    }

    public ThrusterTier getTier() {
        return this.tier;
    }

    public static enum ThrusterTier implements IStringSerializable
    {
        SIMPLE("simple", 420000.0, 100),
        ADVANCED("advanced", 1260000.0, 300);

        private final String name;
        private final double thrust;
        private final int drain;

        private ThrusterTier(String name, double thrust, int drain) {
            this.name = name;
            this.thrust = thrust;
            this.drain = drain;
        }

        public String func_176610_l() {
            return this.name;
        }

        public double getThrust() {
            return this.thrust;
        }

        public int getDrain() {
            return this.drain;
        }
    }
}

