/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.api.data.ITerrainScan;
import net.gegy1000.psf.server.capability.CapabilityModuleData;
import net.gegy1000.psf.server.modules.EmptyModule;
import net.gegy1000.psf.server.modules.data.EmptyTerrainScan;
import net.gegy1000.psf.server.modules.data.TerrainScanData;
import net.minecraft.block.material.MapColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;

public class ModuleTerrainScanner
extends EmptyModule {
    public static final int SCAN_RANGE = 2;
    private TerrainScanData scanData;
    private boolean scanned;

    public ModuleTerrainScanner() {
        super("terrain_scanner");
    }

    @Override
    public void onSatelliteTick(ISatellite satellite) {
        BlockPos position;
        World world = satellite.getWorld();
        if (world.func_175667_e(position = satellite.getPosition())) {
            this.scanData = this.scan(world, new ChunkPos(position.func_177958_n() >> 4, position.func_177952_p() >> 4));
            this.dirty(true);
        }
    }

    private TerrainScanData scan(World world, ChunkPos origin) {
        int minHeight = 256;
        int maxHeight = 0;
        TerrainScanData scanData = new TerrainScanData();
        for (int chunkZ = -2; chunkZ <= 2; ++chunkZ) {
            for (int chunkX = -2; chunkX <= 2; ++chunkX) {
                Chunk chunk = world.func_72964_e(origin.field_77276_a + chunkX, origin.field_77275_b + chunkZ);
                scanData.addChunk(this.scanChunk(new ChunkPos(chunkX, chunkZ), chunk));
                int height = chunk.func_76625_h() + 8;
                if (height > maxHeight) {
                    maxHeight = height;
                }
                if (height >= minHeight) continue;
                minHeight = height;
            }
        }
        scanData.setMinHeight(minHeight);
        scanData.setMaxHeight(maxHeight);
        this.scanned = true;
        return scanData;
    }

    private TerrainScanData.ChunkData scanChunk(ChunkPos chunkPos, Chunk chunk) {
        byte[] blockColors = new byte[65536];
        int index = 0;
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                for (int localY = 0; localY < 256; ++localY) {
                    MapColor mapColor = chunk.func_186032_a(localX, localY, localZ).func_185909_g(null, null);
                    blockColors[index++] = (byte)mapColor.field_76290_q;
                }
            }
        }
        return new TerrainScanData.ChunkData(chunkPos, blockColors);
    }

    @Override
    public int getTickInterval() {
        return this.scanned ? 1200 : 1;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        if (this.scanData != null) {
            compound.func_74782_a("scan_data", (NBTBase)this.scanData.serializeNBT());
        }
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        if (compound.func_74764_b("scan_data")) {
            this.scanData = new TerrainScanData();
            this.scanData.deserializeNBT(compound.func_74775_l("scan_data"));
            this.scanned = true;
        }
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityModuleData.TERRAIN_SCAN) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityModuleData.TERRAIN_SCAN) {
            ITerrainScan terrainScan = this.scanData != null ? this.scanData : new EmptyTerrainScan(2);
            return (T)CapabilityModuleData.TERRAIN_SCAN.cast((Object)terrainScan);
        }
        return super.getCapability(capability, facing);
    }
}

