/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.api.data.ILaser;
import net.gegy1000.psf.client.render.laser.LaserRenderer;
import net.gegy1000.psf.server.capability.CapabilityModuleData;
import net.gegy1000.psf.server.modules.EmptyModule;
import net.gegy1000.psf.server.modules.data.PacketLaserState;
import net.gegy1000.psf.server.network.PSFNetworkHandler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@ParametersAreNonnullByDefault
public class ModuleSpaceLaser
extends EmptyModule
implements ILaser {
    private static final int POWER_REQ = 10000;
    private static final int POWER_PER_TICK = 100;
    private static final int DELAY_TIME = 100;
    @Nullable
    private BlockPos target;
    private int powerUsed;
    private int fireDelay;

    public ModuleSpaceLaser() {
        super("laser");
    }

    @Override
    public void onSatelliteTick(@Nonnull ISatellite satellite) {
        super.onSatelliteTick(satellite);
        if (this.isActive()) {
            if (this.powerUsed < 10000) {
                IEnergyStorage source;
                Collection powerSources = satellite.getModuleCaps(CapabilityEnergy.ENERGY);
                int powerToUse = 100;
                Iterator iterator = powerSources.iterator();
                while (iterator.hasNext() && (powerToUse -= (source = (IEnergyStorage)iterator.next()).extractEnergy(powerToUse, false)) > 0) {
                }
                this.powerUsed += 100 - powerToUse;
            }
            if (this.powerUsed >= 10000) {
                BlockPos landing = satellite.getWorld().func_175645_m(this.target);
                if (this.fireDelay < 100) {
                    Random rand;
                    if (this.fireDelay == 0) {
                        this.sendState(satellite, LaserRenderer.LaserState.FIRING);
                    }
                    if (100 - this.fireDelay < 30 && (rand = satellite.getWorld().field_73012_v).nextInt(5) == 0) {
                        satellite.getWorld().func_72876_a(null, (double)(landing.func_177958_n() + (rand.nextInt(7) - 3)), (double)(landing.func_177956_o() + 1), (double)(landing.func_177952_p() + (rand.nextInt(7) - 3)), 1.0f, true);
                    }
                    ++this.fireDelay;
                } else {
                    satellite.getWorld().func_72876_a(null, (double)landing.func_177958_n(), (double)landing.func_177956_o(), (double)landing.func_177952_p(), 15.0f, true);
                    satellite.getWorld().func_72876_a(null, (double)landing.func_177958_n(), (double)(landing.func_177956_o() - 3), (double)landing.func_177952_p(), 15.0f, true);
                    satellite.getWorld().func_72876_a(null, (double)landing.func_177958_n(), (double)(landing.func_177956_o() - 6), (double)landing.func_177952_p(), 15.0f, true);
                    this.sendState(satellite, LaserRenderer.LaserState.COMPLETE);
                    this.target = null;
                    this.powerUsed = 0;
                    this.fireDelay = 0;
                }
            }
        }
    }

    @Override
    public int getTickInterval() {
        return this.isActive() ? 1 : Integer.MAX_VALUE;
    }

    @Override
    public boolean isActive() {
        return this.target != null;
    }

    @Override
    public boolean activate(ISatellite craft, BlockPos target) {
        BlockPos oldTarget = this.target;
        if (oldTarget != null) {
            this.sendState(craft, oldTarget, LaserRenderer.LaserState.COMPLETE);
        }
        if (craft.getWorld().func_175645_m(craft.getPosition()).func_177951_i((Vec3i)target) <= 4096.0) {
            this.target = target;
            this.sendState(craft, LaserRenderer.LaserState.CHARGING);
            return true;
        }
        return false;
    }

    private void sendState(ISatellite craft, BlockPos target, LaserRenderer.LaserState state) {
        PSFNetworkHandler.network.sendToDimension((IMessage)new PacketLaserState(target, state), craft.getWorld().field_73011_w.getDimension());
    }

    private void sendState(ISatellite craft, LaserRenderer.LaserState state) {
        BlockPos p = this.target;
        if (p != null) {
            this.sendState(craft, p, state);
        }
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityModuleData.SPACE_LASER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityModuleData.SPACE_LASER) {
            return (T)CapabilityModuleData.SPACE_LASER.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

