/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.api.IAdditionalMass;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.server.capability.CapabilityModuleData;
import net.gegy1000.psf.server.fluid.PSFFluidRegistry;
import net.gegy1000.psf.server.modules.EmptyModule;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerFluidMap;

public class ModuleFuelTank
extends EmptyModule
implements IModule {
    private static final int CAPACITY = 250;
    private final FluidTank keroseneTank = new FluidTank(PSFFluidRegistry.KEROSENE, 0, 250);
    private final FluidTank liquidOxygenTank = new FluidTank(PSFFluidRegistry.LIQUID_OXYGEN, 0, 250);
    private final FuelFluidHandler storage = new FuelFluidHandler();

    public ModuleFuelTank() {
        super("fuel_tank");
        this.storage.addHandler(PSFFluidRegistry.KEROSENE, (IFluidHandler)this.keroseneTank);
        this.storage.addHandler(PSFFluidRegistry.LIQUID_OXYGEN, (IFluidHandler)this.liquidOxygenTank);
    }

    public void setFull() {
        this.keroseneTank.fill(new FluidStack(PSFFluidRegistry.KEROSENE, 250), true);
        this.liquidOxygenTank.fill(new FluidStack(PSFFluidRegistry.LIQUID_OXYGEN, 250), true);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        Capability cap = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        tag.func_74782_a("kerosene_tank", cap.getStorage().writeNBT(cap, (Object)this.keroseneTank, null));
        tag.func_74782_a("liquid_oxygen_tank", cap.getStorage().writeNBT(cap, (Object)this.liquidOxygenTank, null));
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        Capability cap = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        cap.getStorage().readNBT(cap, (Object)this.keroseneTank, null, nbt.func_74781_a("kerosene_tank"));
        cap.getStorage().readNBT(cap, (Object)this.liquidOxygenTank, null, nbt.func_74781_a("liquid_oxygen_tank"));
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.storage);
        }
        if (capability == CapabilityModuleData.ADDITIONAL_MASS) {
            return (T)CapabilityModuleData.ADDITIONAL_MASS.cast((Object)this.storage);
        }
        return super.getCapability(capability, facing);
    }

    private class FuelFluidHandler
    extends FluidHandlerFluidMap
    implements IAdditionalMass {
        private FuelFluidHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            ArrayList tanks = Lists.newArrayList();
            for (final Map.Entry entry : this.handlers.entrySet()) {
                IFluidTankProperties[] tankProperties;
                for (final IFluidTankProperties properties : tankProperties = ((IFluidHandler)entry.getValue()).getTankProperties()) {
                    if (properties.getContents() != null) {
                        tanks.add(properties);
                        continue;
                    }
                    tanks.add(new IFluidTankProperties(){

                        public FluidStack getContents() {
                            return new FluidStack((Fluid)entry.getKey(), 0);
                        }

                        public int getCapacity() {
                            return properties.getCapacity();
                        }

                        public boolean canFill() {
                            return true;
                        }

                        public boolean canDrain() {
                            return true;
                        }

                        public boolean canFillFluidType(FluidStack fluidStack) {
                            return fluidStack.getFluid() == entry.getKey();
                        }

                        public boolean canDrainFluidType(FluidStack fluidStack) {
                            return fluidStack.getFluid() == entry.getKey();
                        }
                    });
                }
            }
            return tanks.toArray(new IFluidTankProperties[0]);
        }

        public int fill(FluidStack resource, boolean doFill) {
            int fill = super.fill(resource, doFill);
            if (fill > 0) {
                ModuleFuelTank.this.dirty(true);
            }
            return fill;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack drain = super.drain(resource, doDrain);
            if (drain != null && drain.amount > 0) {
                ModuleFuelTank.this.dirty(true);
            }
            return drain;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack drain = super.drain(maxDrain, doDrain);
            if (drain != null && drain.amount > 0) {
                ModuleFuelTank.this.dirty(true);
            }
            return drain;
        }

        @Override
        public double getAdditionalMass() {
            double additonalMass = 0.0;
            for (Map.Entry handler : this.handlers.entrySet()) {
                int density = ((Fluid)handler.getKey()).getDensity() * 1000;
                IFluidTankProperties properties = ((IFluidHandler)handler.getValue()).getTankProperties()[0];
                FluidStack contents = properties.getContents();
                if (contents == null) continue;
                additonalMass += (double)contents.amount / (double)properties.getCapacity() * (double)density;
            }
            return additonalMass;
        }
    }
}

