/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.server.capability.CapabilityModuleData;
import net.gegy1000.psf.server.modules.EmptyModule;
import net.gegy1000.psf.server.modules.configs.ConfigBooleanToggle;
import net.gegy1000.psf.server.modules.data.EntityListData;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

@ParametersAreNonnullByDefault
public class ModuleEntityDetector
extends EmptyModule {
    private final ConfigBooleanToggle enabled = new ConfigBooleanToggle("enabled", "Enabled", "Disabled");
    private final int chunkRange;
    private final EntityListData listData = new EntityListData();

    public ModuleEntityDetector(EntityDetectorTier tier) {
        this(tier, tier.getChunkRange());
    }

    public ModuleEntityDetector(int chunkRange) {
        this(EntityDetectorTier.CUSTOM, chunkRange);
    }

    public ModuleEntityDetector(EntityDetectorTier tier, int chunkRange) {
        super("entity_detector." + tier.func_176610_l());
        this.chunkRange = chunkRange;
        this.enabled.modified(null);
        this.registerConfigs(this.enabled);
    }

    @Override
    public void onSatelliteTick(ISatellite satellite) {
        if (this.enabled.value() && satellite.tryExtractEnergy(1000)) {
            World world = satellite.getWorld();
            List entities = world.func_175644_a(EntityLivingBase.class, e -> {
                if (e == null || e instanceof EntityPlayer) {
                    return false;
                }
                return world.func_175678_i(e.func_180425_c()) && this.withinSatelliteRange(satellite, e.func_180425_c());
            });
            this.listData.updateEntities(entities);
        } else {
            this.listData.updateEntities(Collections.emptyList());
        }
    }

    @Override
    public int getTickInterval() {
        return 200;
    }

    private boolean withinSatelliteRange(ISatellite satellite, BlockPos pos) {
        BlockPos entityChunk;
        BlockPos sat = new BlockPos(satellite.getPosition().func_177958_n() >> 4, 0, satellite.getPosition().func_177952_p() >> 4);
        BlockPos diff = sat.func_177973_b((Vec3i)(entityChunk = new BlockPos(pos.func_177958_n() >> 4, 0, pos.func_177952_p() >> 4)));
        return Math.abs(diff.func_177958_n()) <= this.chunkRange && Math.abs(diff.func_177952_p()) <= this.chunkRange;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityModuleData.ENTITY_LIST || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityModuleData.ENTITY_LIST) {
            return (T)CapabilityModuleData.ENTITY_LIST.cast((Object)this.listData);
        }
        return super.getCapability(capability, facing);
    }

    public static enum EntityDetectorTier implements IStringSerializable
    {
        SIMPLE("simple", 1),
        ADVANCED("advanced", 5),
        CUSTOM("custom", 0);

        private final String name;
        private final int chunkRange;

        private EntityDetectorTier(String name, int chunkRange) {
            this.name = name;
            this.chunkRange = chunkRange;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getChunkRange() {
            return this.chunkRange;
        }
    }
}

