/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.gegy1000.psf.api.IController;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.server.block.remote.packet.PacketCraftState;
import net.gegy1000.psf.server.block.remote.packet.PacketOpenRemoteControl;
import net.gegy1000.psf.server.entity.spacecraft.EntitySpacecraft;
import net.gegy1000.psf.server.modules.EmptyModule;
import net.gegy1000.psf.server.modules.configs.ConfigBasicAction;
import net.gegy1000.psf.server.network.PSFNetworkHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ModuleController
extends EmptyModule
implements IController {
    private final ConfigBasicAction deorbit = new ConfigBasicAction("deorbit", TextFormatting.RED + "DEORBIT"){

        @Override
        public void modified() {
            ModuleController.this.deorbiting = true;
        }
    };
    @Nonnull
    private BlockPos pos = BlockPos.field_177992_a;
    boolean deorbiting;

    public ModuleController() {
        super("controller.simple");
        this.registerConfigs(this.deorbit);
    }

    public ModuleController(BlockPos pos) {
        this();
        this.pos = pos;
    }

    @Override
    public Optional<BlockPos> getPosition() {
        return Optional.of(this.pos);
    }

    @Override
    public void onSatelliteTick(ISatellite satellite) {
        super.onSatelliteTick(satellite);
        if (this.deorbiting && satellite.isOrbiting()) {
            this.deorbiting = false;
            EntitySpacecraft entity = new EntitySpacecraft(satellite);
            BlockPos pos = this.getPosition().get();
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, 1000.0, (double)pos.func_177952_p() + 0.5);
            satellite.getWorld().func_72838_d((Entity)entity);
            for (EntityPlayerMP player : satellite.getTrackingPlayers()) {
                PSFNetworkHandler.network.sendTo((IMessage)new PacketCraftState(PacketOpenRemoteControl.SatelliteState.ENTITY, satellite.toListedCraft()), player);
            }
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = super.serializeNBT();
        ret.func_74768_a("controller_x", this.pos.func_177958_n());
        ret.func_74768_a("controller_y", this.pos.func_177956_o());
        ret.func_74768_a("controller_z", this.pos.func_177952_p());
        return ret;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.setPos(new BlockPos(nbt.func_74762_e("controller_x"), nbt.func_74762_e("controller_y"), nbt.func_74762_e("controller_z")));
    }

    public void setPos(@Nonnull BlockPos pos) {
        if (pos == null) {
            throw new NullPointerException("pos");
        }
        this.pos = pos;
    }
}

