/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.server.modules.EmptyModule;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class ModuleBattery
extends EmptyModule
implements IModule {
    private final IEnergyStorage storage;

    public ModuleBattery(BatteryTier tier) {
        this(tier, tier.capacity);
    }

    public ModuleBattery(int capacity) {
        this(BatteryTier.CUSTOM, capacity);
    }

    public ModuleBattery(BatteryTier tier, int capacity) {
        super("battery." + tier.func_176610_l());
        this.storage = new EnergyStorage(capacity, capacity, capacity, capacity){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int ret = super.receiveEnergy(maxReceive, simulate);
                if (ret > 0) {
                    ModuleBattery.this.dirty(true);
                }
                return ret;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                int ret = super.extractEnergy(maxExtract, simulate);
                if (ret > 0) {
                    ModuleBattery.this.dirty(true);
                }
                return ret;
            }
        };
    }

    @Override
    public List<String> getSummary() {
        return Arrays.asList("Energy Stored: " + this.storage.getEnergyStored() + " / " + this.storage.getMaxEnergyStored());
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74782_a("energy", CapabilityEnergy.ENERGY.getStorage().writeNBT(CapabilityEnergy.ENERGY, (Object)this.storage, null));
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        CapabilityEnergy.ENERGY.getStorage().readNBT(CapabilityEnergy.ENERGY, (Object)this.storage, null, nbt.func_74781_a("energy"));
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityEnergy.ENERGY;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing) && capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.storage);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.serializeNBT();
    }

    @Override
    public void readUpdateTag(NBTTagCompound tag) {
        this.deserializeNBT(tag);
    }

    public static enum BatteryTier implements IStringSerializable
    {
        SIMPLE("simple", 100000),
        ADVANCED("advanced", 10000000),
        CUSTOM("custom", 0);

        private final String name;
        private final int capacity;

        private BatteryTier(String name, int capacity) {
            this.name = name;
            this.capacity = capacity;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

