/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.modules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.IModuleConfig;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EmptyModule
implements IModule {
    private final Map<String, IModuleConfig> configs = new HashMap<String, IModuleConfig>();
    @Nonnull
    private UUID id = UUID.randomUUID();
    private ResourceLocation registryName;
    @Nonnull
    private final String name;
    private boolean dirty = true;

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public String getLocalizedName() {
        return I18n.func_135052_a((String)String.format("tile.%s.%s.name", "psf", this.getName()), (Object[])new Object[0]);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_186854_a("id", this.id);
        NBTTagCompound configTag = new NBTTagCompound();
        for (Map.Entry<String, IModuleConfig> e : this.configs.entrySet()) {
            configTag.func_74782_a(e.getKey(), e.getValue().serializeNBT());
        }
        ret.func_74782_a("configs", (NBTBase)configTag);
        return ret;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("idMost")) {
            this.id = nbt.func_186857_a("id");
        }
        NBTTagCompound configTag = nbt.func_74775_l("configs");
        for (Map.Entry<String, IModuleConfig> e : this.configs.entrySet()) {
            IModuleConfig cfg = this.getConfig(e.getKey());
            if (cfg == null) continue;
            cfg.deserializeNBT(configTag.func_74775_l(e.getKey()));
        }
    }

    @Override
    public void dirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected final void registerConfigs(IModuleConfig ... cfgs) {
        for (IModuleConfig cfg : cfgs) {
            this.configs.put(cfg.getKey(), cfg);
        }
    }

    @Override
    @Nullable
    public IModuleConfig getConfig(String key) {
        return this.configs.get(key);
    }

    @Override
    @Nonnull
    public Collection<IModuleConfig> getConfigs() {
        return this.configs.values();
    }

    public EmptyModule(@Nonnull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    @Override
    @Nonnull
    public UUID getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public EmptyModule setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        return this;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }
}

