/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.entity.spacecraft;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.vecmath.Point3d;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftBlockAccess;
import net.gegy1000.psf.server.util.Matrix;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SpacecraftDeconstructor {
    public static Optional<Result> deconstruct(World world, SpacecraftBlockAccess blockAccess, double posX, double posY, double posZ, Matrix rotationMatrix) {
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        HashMap<BlockPos, TileEntity> entities = new HashMap<BlockPos, TileEntity>();
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)blockAccess.getMinPos(), (BlockPos)blockAccess.getMaxPos())) {
            IBlockState state = blockAccess.func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            Point3d point = new Point3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            rotationMatrix.transform(point);
            BlockPos transformedPos = new BlockPos(point.getX() + posX, point.getY() + posY, point.getZ() + posZ);
            IBlockState worldState = world.func_180495_p(transformedPos);
            if (!worldState.func_177230_c().func_176200_f((IBlockAccess)world, transformedPos)) {
                return Optional.empty();
            }
            blocks.put(transformedPos, state);
            TileEntity entity = blockAccess.func_175625_s(pos);
            if (entity == null) continue;
            TileEntity copiedEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)entity.serializeNBT());
            if (copiedEntity == null) {
                PracticalSpaceFireworks.LOGGER.warn("Failed to copy TE when building spacecraft");
                continue;
            }
            copiedEntity.func_174878_a(transformedPos);
            entities.put(transformedPos, copiedEntity);
        }
        return Optional.of(new Result(blocks, entities));
    }

    public static class Result {
        private final Map<BlockPos, IBlockState> blocks;
        private final Map<BlockPos, TileEntity> entities;

        public Result(Map<BlockPos, IBlockState> blocks, Map<BlockPos, TileEntity> entities) {
            this.blocks = blocks;
            this.entities = entities;
        }

        public Map<BlockPos, IBlockState> getBlocks() {
            return this.blocks;
        }

        public Map<BlockPos, TileEntity> getEntities() {
            return this.entities;
        }
    }
}

