/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.entity.spacecraft;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Set;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftBlockAccess;
import net.gegy1000.psf.server.util.PointUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class SpacecraftBuilder {
    private final LongList blockKeys = new LongArrayList();
    private final IntList blockValues = new IntArrayList();
    private final Long2ObjectMap<TileEntity> entities = new Long2ObjectOpenHashMap();
    private BlockPos minPos = BlockPos.field_177992_a;
    private BlockPos maxPos = BlockPos.field_177992_a;

    public void setBlockState(BlockPos pos, IBlockState state) {
        this.updateBounds(pos);
        this.blockKeys.add(pos.func_177986_g());
        this.blockValues.add(Block.func_176210_f((IBlockState)state));
    }

    public void setTileEntity(BlockPos pos, TileEntity entity) {
        this.updateBounds(pos);
        this.entities.put(pos.func_177986_g(), (Object)entity);
    }

    private void updateBounds(BlockPos pos) {
        this.minPos = PointUtils.min(pos, this.minPos);
        this.maxPos = PointUtils.max(pos, this.maxPos);
    }

    public void copyFrom(World world, BlockPos origin, Set<BlockPos> positions) {
        for (BlockPos pos : positions) {
            BlockPos localPos = pos.func_177973_b((Vec3i)origin);
            this.setBlockState(localPos, world.func_180495_p(pos));
            TileEntity entity = world.func_175625_s(pos);
            if (entity == null) continue;
            TileEntity copiedEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)entity.serializeNBT());
            if (copiedEntity == null) {
                PracticalSpaceFireworks.LOGGER.warn("Failed to copy TE when building spacecraft");
                continue;
            }
            copiedEntity.func_174878_a(localPos);
            this.setTileEntity(localPos, copiedEntity);
        }
    }

    public SpacecraftBlockAccess buildBlockAccess(BlockPos origin, World world) {
        int[] blockData = new int[SpacecraftBlockAccess.getDataSize(this.minPos, this.maxPos)];
        for (int i = 0; i < this.blockKeys.size(); ++i) {
            int state;
            BlockPos pos = BlockPos.func_177969_a((long)this.blockKeys.getLong(i));
            blockData[SpacecraftBlockAccess.getPosIndex((BlockPos)pos, (BlockPos)this.minPos, (BlockPos)this.maxPos)] = state = this.blockValues.getInt(i);
        }
        int[] lightData = new int[SpacecraftBlockAccess.getDataSize(this.minPos, this.maxPos)];
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.minPos, (BlockPos)this.maxPos)) {
            lightData[SpacecraftBlockAccess.getPosIndex((BlockPos)pos, (BlockPos)this.minPos, (BlockPos)this.maxPos)] = this.getCombinedLight(world, origin.func_177971_a((Vec3i)pos));
        }
        Biome biome = world.func_180494_b(origin);
        return new SpacecraftBlockAccess(blockData, lightData, this.entities, biome, this.minPos, this.maxPos);
    }

    private int getCombinedLight(World world, BlockPos pos) {
        int skyLight = this.getLightFromNeighborsFor(world, EnumSkyBlock.SKY, pos);
        int blockLight = this.getLightFromNeighborsFor(world, EnumSkyBlock.BLOCK, pos);
        return skyLight << 20 | blockLight << 4;
    }

    private int getLightFromNeighborsFor(World world, EnumSkyBlock type, BlockPos pos) {
        if (!world.field_73011_w.func_191066_m() && type == EnumSkyBlock.SKY) {
            return 0;
        }
        if (pos.func_177956_o() < 0) {
            pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        if (!world.func_175701_a(pos)) {
            return type.field_77198_c;
        }
        if (!world.func_175667_e(pos)) {
            return type.field_77198_c;
        }
        if (world.func_180495_p(pos).func_185916_f()) {
            int lightUp = world.func_175642_b(type, pos.func_177984_a());
            int lightEast = world.func_175642_b(type, pos.func_177974_f());
            int lightWest = world.func_175642_b(type, pos.func_177976_e());
            int lightSouth = world.func_175642_b(type, pos.func_177968_d());
            int lightNorth = world.func_175642_b(type, pos.func_177978_c());
            return Math.max(lightUp, Math.max(lightEast, Math.max(lightWest, Math.max(lightSouth, lightNorth))));
        }
        return world.func_175726_f(pos).func_177413_a(type, pos);
    }
}

