/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.entity.spacecraft;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.IController;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.server.capability.CapabilityController;
import net.gegy1000.psf.server.capability.CapabilityModule;
import net.gegy1000.psf.server.entity.spacecraft.LaunchMetadata;
import net.gegy1000.psf.server.modules.ModuleThruster;
import net.gegy1000.psf.server.util.BlockMassHandler;
import net.gegy1000.psf.server.util.PointUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpacecraftBlockAccess
implements IBlockAccess {
    private final int[] blockData;
    private final int[] lightData;
    private final Long2ObjectMap<TileEntity> entities;
    private final Biome biome;
    private final BlockPos minPos;
    private final BlockPos maxPos;

    public BlockPos getMinPos() {
        return this.minPos;
    }

    public BlockPos getMaxPos() {
        return this.maxPos;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        int posIndex = SpacecraftBlockAccess.getPosIndex(pos, this.minPos, this.maxPos);
        if (posIndex > -1) {
            return Block.func_176220_d((int)this.blockData[posIndex]);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return (TileEntity)this.entities.get(pos.func_177986_g());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175626_b(BlockPos pos, int lightValue) {
        int posIndex = SpacecraftBlockAccess.getPosIndex(pos, this.minPos, this.maxPos);
        if (posIndex > -1) {
            return this.lightData[posIndex];
        }
        return 0xF00000;
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.biome;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    @Nonnull
    public WorldType func_175624_G() {
        return WorldType.field_77137_b;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        IBlockState state = this.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)this, pos, side);
    }

    @Nonnull
    public Collection<TileEntity> getEntities() {
        return this.entities.values();
    }

    @Nullable
    public IController findController() {
        for (TileEntity entity : this.getEntities()) {
            if (!entity.hasCapability(CapabilityController.INSTANCE, null)) continue;
            return (IController)entity.getCapability(CapabilityController.INSTANCE, null);
        }
        return null;
    }

    @Nonnull
    public List<IModule> findModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        for (TileEntity entity : this.getEntities()) {
            if (!entity.hasCapability(CapabilityModule.INSTANCE, null)) continue;
            modules.add((IModule)entity.getCapability(CapabilityModule.INSTANCE, null));
        }
        return modules;
    }

    public SpacecraftBlockAccess[] splitVertically(World world, Block separator) {
        ArrayList<SpacecraftBlockAccess> split = new ArrayList<SpacecraftBlockAccess>();
        int startY = this.minPos.func_177956_o();
        block0: for (int y = this.minPos.func_177956_o(); y <= this.maxPos.func_177956_o(); ++y) {
            for (BlockPos pos : BlockPos.func_191532_a((int)this.minPos.func_177958_n(), (int)y, (int)this.minPos.func_177952_p(), (int)this.maxPos.func_177958_n(), (int)y, (int)this.maxPos.func_177952_p())) {
                if (this.func_180495_p(pos).func_177230_c() != separator) continue;
                split.add(this.splitSection(world, startY, y));
                startY = y + 1;
                continue block0;
            }
        }
        if (this.maxPos.func_177956_o() - startY > 0) {
            split.add(this.splitSection(world, startY, this.maxPos.func_177956_o()));
        }
        return split.toArray(new SpacecraftBlockAccess[0]);
    }

    private SpacecraftBlockAccess splitSection(World world, int startY, int endY) {
        BlockPos fittedMinPos = this.maxPos;
        BlockPos fittedMaxPos = this.minPos;
        for (BlockPos pos : BlockPos.func_191531_b((int)this.minPos.func_177958_n(), (int)startY, (int)this.minPos.func_177952_p(), (int)this.maxPos.func_177958_n(), (int)endY, (int)this.maxPos.func_177952_p())) {
            if (this.func_175623_d(pos)) continue;
            fittedMinPos = PointUtils.min(fittedMinPos, pos);
            fittedMaxPos = PointUtils.max(fittedMaxPos, pos);
        }
        BlockPos minPos = fittedMinPos.func_177979_c(startY);
        BlockPos maxPos = fittedMaxPos.func_177979_c(startY);
        BlockPos offset = minPos.func_177973_b((Vec3i)new BlockPos(this.minPos.func_177958_n(), startY, this.minPos.func_177952_p()));
        int dataSize = SpacecraftBlockAccess.getDataSize(minPos, maxPos);
        int[] blockData = new int[dataSize];
        int[] lightData = new int[dataSize];
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)minPos, (BlockPos)maxPos)) {
            int localIndex = SpacecraftBlockAccess.getPosIndex(pos, minPos, maxPos);
            int globalIndex = SpacecraftBlockAccess.getPosIndex(pos.func_177973_b((Vec3i)offset), this.minPos, this.maxPos);
            blockData[localIndex] = this.blockData[globalIndex];
            lightData[localIndex] = this.lightData[globalIndex];
        }
        Long2ObjectOpenHashMap entities = new Long2ObjectOpenHashMap();
        for (TileEntity entity : this.getEntities()) {
            int entityY = entity.func_174877_v().func_177956_o();
            if (entityY < startY || entityY > endY) continue;
            BlockPos localPos = entity.func_174877_v().func_177971_a((Vec3i)offset);
            TileEntity copiedEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)entity.serializeNBT());
            if (copiedEntity == null) {
                PracticalSpaceFireworks.LOGGER.warn("Failed to copy TE for spacecraft");
                continue;
            }
            copiedEntity.func_174878_a(localPos);
            entities.put(localPos.func_177986_g(), (Object)copiedEntity);
        }
        return new SpacecraftBlockAccess(blockData, lightData, (Long2ObjectMap<TileEntity>)entities, this.biome, minPos, maxPos);
    }

    public LaunchMetadata buildLaunchMetadata() {
        double mass = 0.0;
        ImmutableList.Builder thrusters = ImmutableList.builder();
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.minPos, (BlockPos)this.maxPos)) {
            IBlockState state = this.func_180495_p(pos);
            mass += BlockMassHandler.getMass(state);
        }
        for (TileEntity entity : this.getEntities()) {
            IModule module2;
            if (!entity.hasCapability(CapabilityModule.INSTANCE, null) || !((module2 = (IModule)entity.getCapability(CapabilityModule.INSTANCE, null)) instanceof ModuleThruster)) continue;
            ModuleThruster.ThrusterTier tier = ((ModuleThruster)module2).getTier();
            thrusters.add((Object)new LaunchMetadata.Thruster(entity.func_174877_v(), tier.getThrust(), tier.getDrain()));
        }
        List<IModule> modules = this.findModules();
        List<IFluidHandler> fuelTanks = modules.stream().filter(module -> module.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).map(module -> (IFluidHandler)module.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).collect(Collectors.toList());
        return new LaunchMetadata(modules, fuelTanks, (ImmutableList<LaunchMetadata.Thruster>)thrusters.build(), mass);
    }

    public NBTTagCompound serialize(NBTTagCompound compound) {
        compound.func_74768_a("min_x", this.minPos.func_177958_n());
        compound.func_74768_a("min_y", this.minPos.func_177956_o());
        compound.func_74768_a("min_z", this.minPos.func_177952_p());
        compound.func_74768_a("max_x", this.maxPos.func_177958_n());
        compound.func_74768_a("max_y", this.maxPos.func_177956_o());
        compound.func_74768_a("max_z", this.maxPos.func_177952_p());
        if (this.biome.getRegistryName() != null) {
            compound.func_74778_a("biome", this.biome.getRegistryName().toString());
        }
        compound.func_74783_a("block_data", this.blockData);
        compound.func_74783_a("light_data", this.lightData);
        NBTTagList entityList = new NBTTagList();
        for (Map.Entry entry : this.entities.entrySet()) {
            entityList.func_74742_a((NBTBase)((TileEntity)entry.getValue()).serializeNBT());
        }
        compound.func_74782_a("entities", (NBTBase)entityList);
        return compound;
    }

    public static SpacecraftBlockAccess deserialize(NBTTagCompound compound) {
        int[] lightData;
        BlockPos minPos = new BlockPos(compound.func_74762_e("min_x"), compound.func_74762_e("min_y"), compound.func_74762_e("min_z"));
        BlockPos maxPos = new BlockPos(compound.func_74762_e("max_x"), compound.func_74762_e("max_y"), compound.func_74762_e("max_z"));
        Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(compound.func_74779_i("biome")));
        if (biome == null) {
            PracticalSpaceFireworks.LOGGER.warn("Failed to load biome with id {}", (Object)compound.func_74779_i("biome"));
            biome = Biomes.field_180279_ad;
        }
        int expectedLength = SpacecraftBlockAccess.getDataSize(minPos, maxPos);
        int[] blockData = compound.func_74759_k("block_data");
        if (blockData.length != expectedLength) {
            PracticalSpaceFireworks.LOGGER.error("Loaded block data array of wrong length");
            blockData = new int[expectedLength];
        }
        if ((lightData = compound.func_74759_k("light_data")).length != expectedLength) {
            PracticalSpaceFireworks.LOGGER.error("Loaded light data array of wrong length");
            lightData = new int[expectedLength];
        }
        Long2ObjectOpenHashMap entities = new Long2ObjectOpenHashMap();
        NBTTagList entityList = compound.func_150295_c("entities", 10);
        for (int i = 0; i < entityList.func_74745_c(); ++i) {
            NBTTagCompound entityTag = entityList.func_150305_b(i);
            TileEntity entity = TileEntity.func_190200_a(null, (NBTTagCompound)entityTag);
            if (entity == null) {
                PracticalSpaceFireworks.LOGGER.warn("Failed to deserialize TE for spacecraft");
                continue;
            }
            entities.put(entity.func_174877_v().func_177986_g(), (Object)entity);
        }
        return new SpacecraftBlockAccess(blockData, lightData, (Long2ObjectMap<TileEntity>)entities, biome, minPos, maxPos);
    }

    public void serialize(ByteBuf buffer) {
        buffer.writeLong(this.minPos.func_177986_g());
        buffer.writeLong(this.maxPos.func_177986_g());
        buffer.writeShort(Biome.func_185362_a((Biome)this.biome) & 0xFFFF);
        for (int block : this.blockData) {
            buffer.writeShort(block & 0xFFFF);
        }
        for (int light : this.lightData) {
            buffer.writeInt(light);
        }
        buffer.writeShort(this.entities.size() & 0xFFFF);
        Object object = this.entities.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((TileEntity)entry.getValue()).serializeNBT());
        }
    }

    public static SpacecraftBlockAccess deserialize(ByteBuf buffer) {
        BlockPos minPos = BlockPos.func_177969_a((long)buffer.readLong());
        BlockPos maxPos = BlockPos.func_177969_a((long)buffer.readLong());
        Biome biome = Biome.func_180276_a((int)buffer.readUnsignedShort(), (Biome)Biomes.field_180279_ad);
        int[] blockData = new int[SpacecraftBlockAccess.getDataSize(minPos, maxPos)];
        for (int i = 0; i < blockData.length; ++i) {
            blockData[i] = buffer.readUnsignedShort();
        }
        int[] lightData = new int[SpacecraftBlockAccess.getDataSize(minPos, maxPos)];
        for (int i = 0; i < lightData.length; ++i) {
            lightData[i] = buffer.readInt();
        }
        int entityCount = buffer.readUnsignedShort();
        Long2ObjectOpenHashMap entities = new Long2ObjectOpenHashMap();
        for (int i = 0; i < entityCount; ++i) {
            NBTTagCompound entityTag = ByteBufUtils.readTag((ByteBuf)buffer);
            TileEntity entity = TileEntity.func_190200_a(null, (NBTTagCompound)entityTag);
            if (entity == null) {
                PracticalSpaceFireworks.LOGGER.warn("Failed to deserialize TE for spacecraft");
                continue;
            }
            entities.put(entity.func_174877_v().func_177986_g(), (Object)entity);
        }
        return new SpacecraftBlockAccess(blockData, lightData, (Long2ObjectMap<TileEntity>)entities, biome, minPos, maxPos);
    }

    static int getPosIndex(BlockPos pos, BlockPos minPos, BlockPos maxPos) {
        int sizeX = maxPos.func_177958_n() - minPos.func_177958_n() + 1;
        int sizeY = maxPos.func_177956_o() - minPos.func_177956_o() + 1;
        int sizeZ = maxPos.func_177952_p() - minPos.func_177952_p() + 1;
        int localX = pos.func_177958_n() - minPos.func_177958_n();
        int localY = pos.func_177956_o() - minPos.func_177956_o();
        int localZ = pos.func_177952_p() - minPos.func_177952_p();
        if (localX >= 0 && localY >= 0 && localZ >= 0 && localX < sizeX && localY < sizeY && localZ < sizeZ) {
            return localX + (localZ + localY * sizeZ) * sizeX;
        }
        return -1;
    }

    static int getDataSize(BlockPos minPos, BlockPos maxPos) {
        return (maxPos.func_177958_n() - minPos.func_177958_n() + 1) * (maxPos.func_177956_o() - minPos.func_177956_o() + 1) * (maxPos.func_177952_p() - minPos.func_177952_p() + 1);
    }

    SpacecraftBlockAccess(int[] blockData, int[] lightData, Long2ObjectMap<TileEntity> entities, Biome biome, BlockPos minPos, BlockPos maxPos) {
        this.blockData = blockData;
        this.lightData = lightData;
        this.entities = entities;
        this.biome = biome;
        this.minPos = minPos;
        this.maxPos = maxPos;
    }
}

