/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.entity.spacecraft;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Point3d;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.client.render.spacecraft.model.SpacecraftModel;
import net.gegy1000.psf.server.block.module.BlockModule;
import net.gegy1000.psf.server.block.remote.packet.PacketCraftState;
import net.gegy1000.psf.server.block.remote.packet.PacketOpenRemoteControl;
import net.gegy1000.psf.server.capability.CapabilitySatellite;
import net.gegy1000.psf.server.capability.world.CapabilityWorldData;
import net.gegy1000.psf.server.capability.world.SatelliteWorldData;
import net.gegy1000.psf.server.entity.spacecraft.LaunchMetadata;
import net.gegy1000.psf.server.entity.spacecraft.PacketLaunchCraft;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftBlockAccess;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftBuilder;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftDeconstructor;
import net.gegy1000.psf.server.fluid.PSFFluidRegistry;
import net.gegy1000.psf.server.network.PSFNetworkHandler;
import net.gegy1000.psf.server.satellite.EntityBoundSatellite;
import net.gegy1000.psf.server.util.Matrix;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpacecraft
extends Entity
implements IEntityAdditionalSpawnData {
    private static final double AIR_RESISTANCE = 0.98;
    public static final double GRAVITY = 1.6;
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(EntitySpacecraft.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> ACCELERATION = EntityDataManager.func_187226_a(EntitySpacecraft.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> FORCE = EntityDataManager.func_187226_a(EntitySpacecraft.class, (DataSerializer)DataSerializers.field_187193_c);
    private final Matrix rotationMatrix = new Matrix(3);
    private final EntityBoundSatellite satellite;
    @SideOnly(value=Side.CLIENT)
    public SpacecraftModel model;
    private SpacecraftBlockAccess blockAccess;
    private State state = new Static(this);
    private boolean converted;
    private LaunchMetadata metadata;

    public EntitySpacecraft(World world) {
        this(world, Collections.emptySet(), BlockPos.field_177992_a, null);
    }

    public EntitySpacecraft(World world, Set<BlockPos> positions, @Nonnull BlockPos origin, @Nullable UUID id) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        SpacecraftBuilder builder = new SpacecraftBuilder();
        builder.copyFrom(world, origin, positions);
        this.blockAccess = builder.buildBlockAccess(origin, this.field_70170_p);
        this.satellite = new EntityBoundSatellite(this, id);
        this.initSpacecraft();
    }

    public EntitySpacecraft(ISatellite craft) {
        super(craft.getWorld());
        this.func_70105_a(1.0f, 1.0f);
        this.blockAccess = craft.buildBlockAccess(craft.getWorld());
        this.satellite = new EntityBoundSatellite(this, craft.getId());
        this.initSpacecraft();
    }

    private void initSpacecraft() {
        this.satellite.detectModules();
        this.recalculateRotation();
        this.metadata = this.blockAccess.buildLaunchMetadata();
        if (!this.field_70170_p.field_72995_K) {
            PracticalSpaceFireworks.PROXY.getSatellites().register(this.satellite);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(STATE, (Object)((byte)StateType.STATIC.ordinal()));
        this.field_70180_af.func_187214_a(FORCE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ACCELERATION, (Object)Float.valueOf(0.0f));
    }

    public void func_70071_h_() {
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
        this.field_70181_x -= 0.08;
        State newState = this.state.update();
        if (!this.field_70170_p.field_72995_K) {
            if (this.state.getType() != newState.getType()) {
                this.state = newState;
                this.field_70180_af.func_187227_b(STATE, (Object)((byte)newState.getType().ordinal()));
            }
        } else {
            StateType syncedStateType = StateType.values()[(Byte)this.field_70180_af.func_187225_a(STATE) % StateType.values().length];
            if (syncedStateType != this.state.getType()) {
                this.state = syncedStateType.create(this);
            }
        }
        double lastMotionY = this.field_70181_x;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (lastMotionY <= -1.0 && this.field_70124_G) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v, (float)Math.log10(-lastMotionY * this.metadata.getMass()) + 1.0f, true);
            }
            this.func_70106_y();
        }
        if (this.field_70163_u > 1000.0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.hasCapability(CapabilityWorldData.SATELLITE_INSTANCE, null)) {
                SatelliteWorldData capability = (SatelliteWorldData)this.field_70170_p.getCapability(CapabilityWorldData.SATELLITE_INSTANCE, null);
                ISatellite orbiting = this.satellite.toOrbiting();
                capability.addSatellite(orbiting);
                this.converted = true;
                for (EntityPlayerMP player : orbiting.getTrackingPlayers()) {
                    PSFNetworkHandler.network.sendTo((IMessage)new PacketCraftState(PacketOpenRemoteControl.SatelliteState.ORBIT, orbiting.toListedCraft()), player);
                }
            }
        }
        if ((double)Math.abs(this.field_70177_z - this.field_70126_B) > 0.001 || (double)Math.abs(this.field_70125_A - this.field_70127_C) > 0.001) {
            this.recalculateRotation();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.satellite.tickSatellite(this.field_70173_aa);
        }
        super.func_70071_h_();
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.converted && !this.field_70170_p.field_72995_K) {
            PracticalSpaceFireworks.PROXY.getSatellites().remove(this.satellite);
        }
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        this.func_174826_a(this.calculateEncompassingBounds());
    }

    @Nonnull
    public AxisAlignedBB func_184177_bl() {
        return this.calculateEncompassingBounds();
    }

    @Nonnull
    private AxisAlignedBB calculateEncompassingBounds() {
        ArrayList<AxisAlignedBB> bounds = new ArrayList<AxisAlignedBB>();
        this.collectTransformedBlockBounds(null, bounds);
        AxisAlignedBB ret = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (AxisAlignedBB bb : bounds) {
            ret = ret.func_111270_a(bb);
        }
        return ret;
    }

    public void func_174829_m() {
        AxisAlignedBB bounds = this.calculateEncompassingBounds();
        AxisAlignedBB updatedBounds = this.func_174813_aQ();
        this.field_70165_t += updatedBounds.field_72340_a - bounds.field_72340_a;
        this.field_70163_u += updatedBounds.field_72338_b - bounds.field_72338_b;
        this.field_70161_v += updatedBounds.field_72339_c - bounds.field_72339_c;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70112_a(double distance) {
        return super.func_70112_a(distance / 8.0);
    }

    public void collectTransformedBlockBounds(@Nullable AxisAlignedBB reference, @Nonnull List<AxisAlignedBB> bounds) {
        if (this.blockAccess != null) {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.blockAccess.getMinPos(), (BlockPos)this.blockAccess.getMaxPos())) {
                IBlockState state = this.blockAccess.func_180495_p(pos);
                AxisAlignedBB bb = state.func_185890_d((IBlockAccess)this.blockAccess, pos);
                if (bb == null) continue;
                AxisAlignedBB transformed = this.rotateBoundsEncompassing(bb, pos).func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (reference != null && !reference.func_72326_a(transformed)) continue;
                bounds.add(transformed);
            }
        }
    }

    private AxisAlignedBB rotateBoundsEncompassing(AxisAlignedBB bounds, BlockPos pos) {
        bounds = bounds.func_72317_d((double)pos.func_177958_n() - 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() - 0.5);
        return this.rotationMatrix.transform(bounds);
    }

    private void recalculateRotation() {
        this.rotationMatrix.identity();
        this.rotationMatrix.rotate(180.0f - this.field_70177_z, 0.0, 1.0, 0.0);
        this.rotationMatrix.rotate(this.field_70125_A, 1.0, 0.0, 0.0);
        this.func_174826_a(this.calculateEncompassingBounds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            int yaw;
            float prevRotationYaw = this.field_70177_z;
            float prevRotationPitch = this.field_70125_A;
            for (yaw = Math.round(this.field_70177_z % 360.0f / 90.0f) * 90; yaw < 0; yaw += 360) {
            }
            this.field_70177_z = yaw;
            this.field_70125_A = (float)Math.round(this.field_70125_A / 90.0f) * 90.0f;
            this.recalculateRotation();
            Rotation rotation = Rotation.values()[(yaw / 90 + 2) % 4];
            Optional<SpacecraftDeconstructor.Result> result = SpacecraftDeconstructor.deconstruct(this.field_70170_p, this.blockAccess, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.rotationMatrix);
            if (result.isPresent()) {
                Map<BlockPos, IBlockState> blocks = result.get().getBlocks();
                Map<BlockPos, TileEntity> entities = result.get().getEntities();
                BlockModule.CONVERTING.set(true);
                try {
                    for (Map.Entry<BlockPos, IBlockState> entry : blocks.entrySet()) {
                        this.field_70170_p.func_180501_a(entry.getKey(), entry.getValue().func_185907_a(rotation), 10);
                    }
                    for (Map.Entry<BlockPos, IBlockState> entry : entities.entrySet()) {
                        this.field_70170_p.func_175690_a(entry.getKey(), (TileEntity)entry.getValue());
                    }
                }
                finally {
                    BlockModule.CONVERTING.set(false);
                }
                this.converted = true;
                for (EntityPlayerMP entityPlayerMP : this.satellite.getTrackingPlayers()) {
                    PSFNetworkHandler.network.sendTo((IMessage)new PacketCraftState(PacketOpenRemoteControl.SatelliteState.TILE, this.satellite.toListedCraft()), entityPlayerMP);
                }
                this.func_70106_y();
            } else {
                this.field_70177_z = prevRotationYaw;
                this.field_70125_A = prevRotationPitch;
                this.recalculateRotation();
                return false;
            }
        }
        return true;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("block_data", (NBTBase)this.blockAccess.serialize(new NBTTagCompound()));
        compound.func_74782_a("satellite", (NBTBase)this.satellite.serializeNBT());
        compound.func_74778_a("state", this.state.getType().name());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.blockAccess = SpacecraftBlockAccess.deserialize(compound.func_74775_l("block_data"));
        this.satellite.deserializeNBT(compound.func_74775_l("satellite"));
        this.metadata = this.blockAccess.buildLaunchMetadata();
        String state = compound.func_74779_i("state");
        this.state = StateType.valueOf(state).create(this);
        this.satellite.detectModules();
        this.recalculateRotation();
    }

    public void writeSpawnData(ByteBuf buffer) {
        this.blockAccess.serialize(buffer);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.satellite.serializeNBT());
        buffer.writeBoolean(this.state instanceof Launch);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.blockAccess = SpacecraftBlockAccess.deserialize(buffer);
        this.satellite.deserializeNBT(ByteBufUtils.readTag((ByteBuf)buffer));
        this.model = null;
        this.satellite.detectModules();
        this.recalculateRotation();
        this.metadata = this.blockAccess.buildLaunchMetadata();
    }

    public void setState(StateType state) {
        this.state = state.create(this);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(STATE, (Object)((byte)state.ordinal()));
        }
    }

    public SpacecraftBlockAccess getBlockAccess() {
        return this.blockAccess;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilitySatellite.INSTANCE || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilitySatellite.INSTANCE) {
            return (T)CapabilitySatellite.INSTANCE.cast((Object)this.satellite);
        }
        return (T)super.getCapability(capability, facing);
    }

    public EntityBoundSatellite getSatellite() {
        return this.satellite;
    }

    public State getState() {
        return this.state;
    }

    static {
        PSFNetworkHandler.network.registerMessage(PacketLaunchCraft.Handler.class, PacketLaunchCraft.class, PSFNetworkHandler.nextID(), Side.SERVER);
    }

    public static class Launch
    implements State {
        private final EntitySpacecraft entity;
        private final IFluidHandler fuelHandler;
        private double lastForce;

        public Launch(EntitySpacecraft entity) {
            this.entity = entity;
            this.fuelHandler = entity.metadata.buildFuelHandler();
        }

        @Override
        public State update() {
            World world = this.entity.func_130014_f_();
            double acceleration = 0.0;
            double force = 0.0;
            if (world.field_72995_K) {
                acceleration = ((Float)this.entity.field_70180_af.func_187225_a(ACCELERATION)).floatValue();
                force = ((Float)this.entity.field_70180_af.func_187225_a(FORCE)).floatValue();
            } else {
                int totalDrain = this.entity.metadata.getTotalFuelDrain() / 20;
                FluidStack keroseneResult = this.fuelHandler.drain(new FluidStack(PSFFluidRegistry.KEROSENE, totalDrain), true);
                FluidStack liquidOxygenResult = this.fuelHandler.drain(new FluidStack(PSFFluidRegistry.LIQUID_OXYGEN, totalDrain), true);
                if (keroseneResult != null && keroseneResult.amount > 0 && liquidOxygenResult != null && liquidOxygenResult.amount > 0) {
                    force = this.entity.metadata.getTotalForce();
                    acceleration = force / this.entity.metadata.getMass() / 20.0;
                }
                this.entity.field_70180_af.func_187227_b(ACCELERATION, (Object)Float.valueOf((float)acceleration));
                this.entity.field_70180_af.func_187227_b(FORCE, (Object)Float.valueOf((float)force));
            }
            this.lastForce = force;
            if (acceleration > 1.0E-4) {
                this.entity.field_70181_x += acceleration;
                this.entity.field_70177_z = (float)((double)this.entity.field_70177_z + Math.max(this.entity.field_70181_x, 0.0) * 0.5);
                if (world.field_72995_K) {
                    for (LaunchMetadata.Thruster thruster : this.entity.metadata.getThrusters()) {
                        BlockPos thrusterPos = thruster.getPos();
                        Point3d thrusterPoint = new Point3d((double)thrusterPos.func_177958_n(), (double)thrusterPos.func_177956_o(), (double)thrusterPos.func_177952_p());
                        this.entity.rotationMatrix.transform(thrusterPoint);
                        double posX = this.entity.field_70165_t + thrusterPoint.x;
                        double posY = this.entity.field_70163_u + thrusterPoint.y;
                        double posZ = this.entity.field_70161_v + thrusterPoint.z;
                        for (int i = 0; i < 30; ++i) {
                            double motionX = (this.entity.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.3;
                            double motionY = -acceleration;
                            double motionZ = (this.entity.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.3;
                            world.func_175682_a(EnumParticleTypes.FLAME, true, posX + motionX, posY, posZ + motionZ, motionX, motionY, motionZ, new int[0]);
                        }
                    }
                }
                return this;
            }
            return StateType.STATIC.create(this.entity);
        }

        @Override
        public double getCameraShake() {
            return this.lastForce * 5.0E-7;
        }

        @Override
        public StateType getType() {
            return StateType.LAUNCH;
        }
    }

    public static class Static
    implements State {
        private final EntitySpacecraft entity;

        public Static(EntitySpacecraft entity) {
            this.entity = entity;
        }

        @Override
        public State update() {
            if (!this.entity.field_70170_p.field_72995_K) {
                this.entity.field_70180_af.func_187227_b(ACCELERATION, (Object)Float.valueOf(0.0f));
            }
            return this;
        }

        @Override
        public StateType getType() {
            return StateType.STATIC;
        }
    }

    public static interface State {
        default public State update() {
            return this;
        }

        default public double getCameraShake() {
            return 0.0;
        }

        public StateType getType();
    }

    public static enum StateType {
        STATIC{

            @Override
            protected State create(EntitySpacecraft entity) {
                return new Static(entity);
            }
        }
        ,
        LAUNCH{

            @Override
            protected State create(EntitySpacecraft entity) {
                return new Launch(entity);
            }
        };


        protected abstract State create(EntitySpacecraft var1);
    }
}

