/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.capability.world;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.server.capability.world.CapabilityWorldData;
import net.gegy1000.psf.server.satellite.OrbitingSatellite;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public interface SatelliteWorldData
extends ICapabilitySerializable<NBTTagCompound> {
    @Nonnull
    public World getWorld();

    public void addSatellite(@Nonnull ISatellite var1);

    public void removeSatellite(@Nonnull UUID var1);

    @Nullable
    public ISatellite getSatellite(UUID var1);

    @Nonnull
    public Collection<ISatellite> getSatellites();

    public static class Impl
    implements SatelliteWorldData {
        private final World world;
        private final Map<UUID, ISatellite> satellites = new HashMap<UUID, ISatellite>();

        public Impl(World world) {
            this.world = world;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityWorldData.SATELLITE_INSTANCE;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)CapabilityWorldData.SATELLITE_INSTANCE.cast((Object)this);
            }
            return null;
        }

        @Override
        @Nonnull
        public World getWorld() {
            return this.world;
        }

        @Override
        public void addSatellite(@Nonnull ISatellite satellite) {
            this.satellites.put(satellite.getId(), satellite);
            PracticalSpaceFireworks.PROXY.getSatellites().register(satellite);
        }

        @Override
        public void removeSatellite(@Nonnull UUID id) {
            this.satellites.remove(id);
            PracticalSpaceFireworks.PROXY.getSatellites().remove(id);
        }

        @Override
        @Nullable
        public ISatellite getSatellite(UUID uuid) {
            return this.satellites.get(uuid);
        }

        @Override
        @Nonnull
        public Collection<ISatellite> getSatellites() {
            return Collections.unmodifiableCollection(this.satellites.values());
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList satelliteList = new NBTTagList();
            for (ISatellite satellite : this.getSatellites()) {
                satelliteList.func_74742_a((NBTBase)satellite.serializeNBT());
            }
            compound.func_74782_a("satellites", (NBTBase)satelliteList);
            return compound;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            NBTTagList satelliteList = compound.func_150295_c("satellites", 10);
            for (int i = 0; i < satelliteList.func_74745_c(); ++i) {
                this.addSatellite(OrbitingSatellite.deserialize(this.getWorld(), satelliteList.func_150305_b(i)));
            }
        }
    }
}

