/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote.tile;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.block.remote.packet.PacketRequestVisual;
import net.gegy1000.psf.server.block.remote.packet.PacketSetName;
import net.gegy1000.psf.server.network.PSFNetworkHandler;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@ParametersAreNonnullByDefault
public class TileListedSpacecraft
implements IListedSpacecraft {
    private final ISatellite satellite;

    public TileListedSpacecraft(ISatellite satellite) {
        this.satellite = satellite;
    }

    @Override
    public UUID getId() {
        return this.satellite.getId();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.satellite.getName();
    }

    @Override
    public void setName(@Nonnull String name) {
        PSFNetworkHandler.network.sendToServer((IMessage)new PacketSetName(this.satellite.getId(), name));
        this.satellite.setName(name);
    }

    @Override
    @Nonnull
    public BlockPos getPosition() {
        return this.satellite.getPosition();
    }

    @Override
    public void requestVisualData() {
        PSFNetworkHandler.network.sendToServer((IMessage)new PacketRequestVisual(this.satellite.getId()));
    }
}

