/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.IModuleFactory;
import net.gegy1000.psf.client.IVisualReceiver;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftBlockAccess;
import net.gegy1000.psf.server.modules.Modules;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketVisualData
implements IMessage {
    private SpacecraftBlockAccess blockAccess;
    private Collection<IModule> modules = new ArrayList<IModule>();

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.modules.size());
        for (IModule m : this.modules) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)m.getRegistryName().toString());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((NBTTagCompound)m.serializeNBT()));
        }
        this.blockAccess.serialize(buf);
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
            NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
            IModuleFactory factory = (IModuleFactory)Modules.get().getValue(id);
            if (factory == null) continue;
            IModule m = (IModule)factory.get();
            m.deserializeNBT((NBTBase)tag);
            this.modules.add(m);
        }
        this.blockAccess = SpacecraftBlockAccess.deserialize(buf);
    }

    public PacketVisualData(SpacecraftBlockAccess blockAccess, Collection<IModule> modules) {
        this.blockAccess = blockAccess;
        this.modules = modules;
    }

    public PacketVisualData() {
    }

    public static class Handler
    implements IMessageHandler<PacketVisualData, IMessage> {
        public IMessage onMessage(PacketVisualData message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> this.updateVisualClient(message));
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void updateVisualClient(PacketVisualData message) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui instanceof IVisualReceiver) {
                ((IVisualReceiver)gui).setVisual(new IListedSpacecraft.Visual(message.blockAccess, message.modules));
            }
        }
    }
}

