/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.ISatellite;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTrackCraft
implements IMessage {
    private UUID id;
    private boolean track;

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.writeBoolean(this.track);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.track = buf.readBoolean();
    }

    public PacketTrackCraft() {
    }

    public PacketTrackCraft(UUID id, boolean track) {
        this.id = id;
        this.track = track;
    }

    public static class Handler
    implements IMessageHandler<PacketTrackCraft, IMessage> {
        public IMessage onMessage(PacketTrackCraft message, MessageContext ctx) {
            PracticalSpaceFireworks.PROXY.handlePacket(ctx, player -> {
                EntityPlayerMP p = (EntityPlayerMP)player;
                ISatellite craft = PracticalSpaceFireworks.PROXY.getSatellites().get(message.id);
                if (craft != null) {
                    if (message.track) {
                        craft.track(p);
                    } else {
                        craft.untrack(p);
                    }
                }
            });
            return null;
        }
    }
}

