/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.ISatellite;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetName
implements IMessage {
    private UUID uuid;
    private String name;

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public PacketSetName(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public PacketSetName() {
    }

    public static class Handler
    implements IMessageHandler<PacketSetName, IMessage> {
        public IMessage onMessage(PacketSetName message, MessageContext ctx) {
            PracticalSpaceFireworks.PROXY.handlePacket(ctx, player -> {
                World world = player.field_70170_p;
                ISatellite satellite = PracticalSpaceFireworks.PROXY.getSatellites().get(message.uuid);
                if (satellite != null) {
                    satellite.setName(message.name);
                }
            });
            return null;
        }
    }
}

