/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.server.block.remote.GuiSelectCraft;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.block.remote.TileRemoteControlSystem;
import net.gegy1000.psf.server.block.remote.entity.EntityListedSpacecraft;
import net.gegy1000.psf.server.block.remote.orbiting.OrbitingListedSpacecraft;
import net.gegy1000.psf.server.block.remote.tile.TileListedSpacecraft;
import net.gegy1000.psf.server.capability.CapabilitySatellite;
import net.gegy1000.psf.server.entity.spacecraft.EntitySpacecraft;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketOpenRemoteControl
implements IMessage {
    private BlockPos pos;
    @Nonnull
    private Map<SatelliteState, List<IListedSpacecraft>> byType = new HashMap<SatelliteState, List<IListedSpacecraft>>();

    public PacketOpenRemoteControl(BlockPos pos, @Nonnull EnumMap<SatelliteState, List<IListedSpacecraft>> crafts) {
        this.byType = crafts;
        this.pos = pos;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        for (SatelliteState state : SatelliteState.values()) {
            List group = this.byType.getOrDefault((Object)state, new ArrayList());
            buf.writeShort(group.size() & 0xFFFF);
            for (IListedSpacecraft satellite : group) {
                buf.writeLong(satellite.getId().getMostSignificantBits());
                buf.writeLong(satellite.getId().getLeastSignificantBits());
                buf.writeLong(satellite.getPosition().func_177986_g());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)satellite.getName());
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        for (SatelliteState state : SatelliteState.values()) {
            int count = buf.readUnsignedShort();
            for (int i = 0; i < count; ++i) {
                UUID uuid = new UUID(buf.readLong(), buf.readLong());
                BlockPos pos = BlockPos.func_177969_a((long)buf.readLong());
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                this.byType.computeIfAbsent(state, t -> new ArrayList()).add(new OrbitingListedSpacecraft(name, pos, uuid));
            }
        }
    }

    public PacketOpenRemoteControl() {
    }

    public static class Handler
    implements IMessageHandler<PacketOpenRemoteControl, IMessage> {
        public IMessage onMessage(PacketOpenRemoteControl message, MessageContext ctx) {
            this.updateCraftListClient(message);
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void updateCraftListClient(PacketOpenRemoteControl message) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                TileEntity entity;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                BlockPos pos = message.pos;
                if (player.field_70170_p.func_175667_e(pos) && player.func_174831_c(pos) <= 64.0 && (entity = player.field_70170_p.func_175625_s(pos)) instanceof TileRemoteControlSystem) {
                    TileRemoteControlSystem controlSystem = (TileRemoteControlSystem)entity;
                    controlSystem.provideServerCrafts(SatelliteState.getAllCrafts((EntityPlayer)player, message.byType));
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSelectCraft(controlSystem));
                }
            });
        }
    }

    public static enum SatelliteState {
        TILE(TileListedSpacecraft.class),
        ENTITY(EntityListedSpacecraft.class),
        ORBIT(OrbitingListedSpacecraft.class);

        private final Class<? extends IListedSpacecraft> clazz;

        public static SatelliteState byClass(Class<? extends IListedSpacecraft> cls) {
            for (SatelliteState state : SatelliteState.values()) {
                if (state.clazz != cls) continue;
                return state;
            }
            return ORBIT;
        }

        public static List<IListedSpacecraft> getAllCrafts(EntityPlayer player, Map<SatelliteState, List<IListedSpacecraft>> raw) {
            ArrayList<IListedSpacecraft> allCrafts = new ArrayList<IListedSpacecraft>();
            for (Map.Entry<SatelliteState, List<IListedSpacecraft>> e : raw.entrySet()) {
                for (IListedSpacecraft craft : e.getValue()) {
                    allCrafts.add(SatelliteState.getCraft(player, e.getKey(), craft));
                }
            }
            return allCrafts;
        }

        public static IListedSpacecraft getCraft(EntityPlayer player, SatelliteState type, IListedSpacecraft craft) {
            switch (type) {
                case TILE: {
                    TileEntity te = player.field_70170_p.func_175625_s(craft.getPosition());
                    if (te == null || !te.hasCapability(CapabilitySatellite.INSTANCE, null)) break;
                    return new TileListedSpacecraft((ISatellite)te.getCapability(CapabilitySatellite.INSTANCE, null));
                }
                case ENTITY: {
                    List entities = player.field_70170_p.func_175644_a(EntitySpacecraft.class, ent -> ent.getSatellite().getId().equals(craft.getId()));
                    if (entities.isEmpty()) break;
                    EntitySpacecraft spacecraft = (EntitySpacecraft)((Object)entities.get(0));
                    return new EntityListedSpacecraft(spacecraft, spacecraft.getSatellite().getId());
                }
            }
            return craft;
        }

        private SatelliteState(Class<? extends IListedSpacecraft> clazz) {
            this.clazz = clazz;
        }
    }
}

