/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.client.IVisualReceiver;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.block.remote.orbiting.OrbitingListedSpacecraft;
import net.gegy1000.psf.server.block.remote.packet.PacketOpenRemoteControl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketCraftState
implements IMessage {
    private PacketOpenRemoteControl.SatelliteState type;
    private IListedSpacecraft craft;

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        buf.writeLong(this.craft.getId().getMostSignificantBits());
        buf.writeLong(this.craft.getId().getLeastSignificantBits());
        buf.writeLong(this.craft.getPosition().func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.craft.getName());
    }

    public void fromBytes(ByteBuf buf) {
        this.type = PacketOpenRemoteControl.SatelliteState.values()[buf.readByte()];
        UUID uuid = new UUID(buf.readLong(), buf.readLong());
        BlockPos pos = BlockPos.func_177969_a((long)buf.readLong());
        String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.craft = new OrbitingListedSpacecraft(name, pos, uuid);
    }

    public PacketCraftState() {
    }

    public PacketCraftState(PacketOpenRemoteControl.SatelliteState type, IListedSpacecraft craft) {
        this.type = type;
        this.craft = craft;
    }

    public static class Handler
    implements IMessageHandler<PacketCraftState, IMessage> {
        public IMessage onMessage(PacketCraftState message, MessageContext ctx) {
            PracticalSpaceFireworks.PROXY.handlePacket(ctx, player -> {
                GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
                if (currentScreen instanceof IVisualReceiver) {
                    ((IVisualReceiver)currentScreen).updateCraft(PacketOpenRemoteControl.SatelliteState.getCraft(player, message.type, message.craft));
                }
            });
            return null;
        }
    }
}

