/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote.entity;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.gegy1000.psf.client.IVisualReceiver;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.block.remote.packet.PacketSetName;
import net.gegy1000.psf.server.entity.spacecraft.EntitySpacecraft;
import net.gegy1000.psf.server.entity.spacecraft.PacketLaunchCraft;
import net.gegy1000.psf.server.network.PSFNetworkHandler;
import net.gegy1000.psf.server.satellite.EntityBoundSatellite;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityListedSpacecraft
implements IListedSpacecraft {
    private final EntitySpacecraft spacecraft;
    private final UUID uuid;

    public EntityListedSpacecraft(EntitySpacecraft spacecraft, UUID uuid) {
        this.spacecraft = spacecraft;
        this.uuid = uuid;
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.spacecraft.getSatellite().getName();
    }

    @Override
    public void setName(@Nonnull String name) {
        PSFNetworkHandler.network.sendToServer((IMessage)new PacketSetName(this.uuid, name));
        this.spacecraft.getSatellite().setName(name);
    }

    @Override
    @Nonnull
    public BlockPos getPosition() {
        return this.spacecraft.func_180425_c();
    }

    @Override
    public void requestVisualData() {
        if (this.spacecraft.func_130014_f_().field_72995_K) {
            this.respondVisualData();
        }
    }

    private void respondVisualData() {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof IVisualReceiver) {
            EntityBoundSatellite satellite = this.spacecraft.getSatellite();
            IListedSpacecraft.Visual visual = new IListedSpacecraft.Visual(satellite.buildBlockAccess(this.spacecraft.func_130014_f_()), satellite.getModules());
            ((IVisualReceiver)currentScreen).setVisual(visual);
        }
    }

    @Override
    public boolean canLaunch() {
        return true;
    }

    @Override
    public void launch() {
        PSFNetworkHandler.network.sendToServer((IMessage)new PacketLaunchCraft(this.spacecraft.func_145782_y()));
    }
}

