/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote.config;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.IModuleConfig;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketConfigChange
implements IMessage {
    private UUID craftId;
    private UUID moduleId;
    private String cfgKey;
    private NBTTagCompound cfgData;

    public PacketConfigChange(IListedSpacecraft iListedSpacecraft, IModule module, IModuleConfig cfg) {
        this.craftId = iListedSpacecraft.getId();
        this.moduleId = module.getId();
        this.cfgKey = cfg.getKey();
        this.cfgData = (NBTTagCompound)cfg.serializeNBT();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.craftId.getMostSignificantBits());
        buf.writeLong(this.craftId.getLeastSignificantBits());
        buf.writeLong(this.moduleId.getMostSignificantBits());
        buf.writeLong(this.moduleId.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.cfgKey);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.cfgData);
    }

    public void fromBytes(ByteBuf buf) {
        this.craftId = new UUID(buf.readLong(), buf.readLong());
        this.moduleId = new UUID(buf.readLong(), buf.readLong());
        this.cfgKey = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.cfgData = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public PacketConfigChange() {
    }

    public static class Handler
    implements IMessageHandler<PacketConfigChange, IMessage> {
        public IMessage onMessage(PacketConfigChange message, MessageContext ctx) {
            PracticalSpaceFireworks.PROXY.handlePacket(ctx, player -> Optional.of(PracticalSpaceFireworks.PROXY.getSatellites().get(message.craftId)).map(ISatellite::getIndexedModules).map(map -> (IModule)map.get(message.moduleId)).map(m -> m.getConfig(message.cfgKey)).ifPresent(cfg -> {
                cfg.deserializeNBT(message.cfgData);
                cfg.modified();
            }));
            return null;
        }
    }
}

