/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.IModuleConfig;
import net.gegy1000.psf.server.block.remote.config.GuiModuleConfig;
import net.gegy1000.psf.server.block.remote.config.IModuleConfigButton;
import net.gegy1000.psf.server.block.remote.config.ModuleConfigButtonAction;
import net.gegy1000.psf.server.block.remote.config.ModuleConfigButtonTextField;
import net.gegy1000.psf.server.block.remote.config.ModuleConfigButtonToggle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

@ParametersAreNonnullByDefault
public class ModuleConfigButtonManager
extends GuiButton {
    private static final boolean scissorAvailable = GLContext.getCapabilities().OpenGL20;
    private final GuiModuleConfig parent;
    private final int startX;
    private final int startY;
    private final int width;
    private final int height;
    private final int edgePadding = 5;
    private final int linePadding = 2;
    private final int lineHeight;
    private int id;
    private int y;
    private int scroll;
    private List<TextHolder> summaries;
    private List<IModuleConfigButton<?>> buttons;

    public ModuleConfigButtonManager(GuiModuleConfig parent, int startX, int startY, int width, int height) {
        super(-42, startX, startY, width, height, "");
        this.lineHeight = Minecraft.func_71410_x().field_71466_p.field_78288_b + 2;
        this.summaries = new ArrayList<TextHolder>();
        this.buttons = new ArrayList();
        this.parent = parent;
        this.startX = startX + 5;
        this.startY = startY + 5;
        this.width = width - 10;
        this.height = height - 10;
    }

    public IModuleConfigButton<?> create(IModule module, IModuleConfig cfg) {
        IModuleConfigButton<ModuleConfigButtonAction> btn;
        switch (cfg.getType()) {
            default: {
                btn = new ModuleConfigButtonAction(this.parent, module, cfg, this.id++, this.startX, this.startY + this.y, this.width, 20);
                break;
            }
            case TOGGLE: {
                btn = new ModuleConfigButtonToggle(this.parent, module, cfg, this.id, this.startX, this.startY + this.y, this.width, 20);
                break;
            }
            case TEXT: {
                btn = new ModuleConfigButtonTextField(this.parent, module, cfg, this.id, Minecraft.func_71410_x().field_71466_p, this.startX, this.startY + this.y, this.width, 20);
            }
        }
        this.buttons.add(btn);
        this.y += ((GuiButton)btn.getButton()).field_146121_g + 2;
        return btn;
    }

    public void addSummary(IModule module) {
        TextHolder holder = new TextHolder(module, this.startX, this.startY + this.y);
        this.summaries.add(holder);
        this.y += holder.height + 2;
    }

    public void spacer(int amount) {
        this.y += amount;
    }

    public void scroll(int delta) {
        this.scroll = MathHelper.func_76125_a((int)(this.scroll - (int)((float)delta / 120.0f * 4.0f)), (int)0, (int)Math.max(this.y - this.height, 0));
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        ModuleConfigButtonManager.func_73734_a((int)(this.startX - 5), (int)(this.startY - 5), (int)(this.startX + this.width + 5), (int)(this.startY + this.height + 5), (int)-1717986919);
        if (scissorAvailable) {
            ScaledResolution sr = new ScaledResolution(mc);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)(this.startX * sr.func_78325_e()), (int)(mc.field_71440_d - (this.startY + this.height) * sr.func_78325_e()), (int)(this.width * sr.func_78325_e()), (int)(this.height * sr.func_78325_e()));
        }
        for (IModuleConfigButton<?> btn : this.buttons) {
            Object b = btn.getButton();
            if (btn.getY() - this.scroll + ((GuiButton)b).field_146121_g <= this.startY || btn.getY() - this.scroll >= this.startY + this.height) continue;
            ((GuiButton)b).field_146129_i = btn.getY() - this.scroll;
            b.func_191745_a(mc, mouseX, mouseY, partialTicks);
        }
        for (TextHolder holder : this.summaries) {
            if (holder.getY() - this.scroll + holder.getHeight() <= this.startY || holder.getY() - this.scroll >= this.startY + this.height) continue;
            int renderY = holder.getY() - this.scroll;
            String title = holder.getModule().getLocalizedName();
            mc.field_71466_p.func_78276_b(title, holder.getX() + this.width / 2 - mc.field_71466_p.func_78256_a(title) / 2, renderY, -16777216);
            renderY += this.lineHeight;
            for (String s : holder.getModule().getSummary()) {
                mc.field_71466_p.func_78276_b(s, holder.getX(), renderY, -16777216);
                renderY += this.lineHeight;
            }
        }
        if (scissorAvailable) {
            GL11.glDisable((int)3089);
        }
    }

    protected final Optional<IModuleConfigButton<?>> getHovered(int mouseX, int mouseY) {
        for (IModuleConfigButton<?> btn : this.buttons) {
            Object b = btn.getButton();
            if (mouseX < ((GuiButton)b).field_146128_h || mouseX > ((GuiButton)b).field_146128_h + ((GuiButton)b).field_146120_f || mouseY < ((GuiButton)b).field_146129_i || mouseY > ((GuiButton)b).field_146129_i + ((GuiButton)b).field_146121_g) continue;
            return Optional.of(btn);
        }
        return Optional.empty();
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        boolean ret = false;
        for (IModuleConfigButton<?> btn : this.buttons) {
            ret |= btn.getButton().func_146116_c(mc, mouseX, mouseY);
        }
        return ret;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        for (IModuleConfigButton<?> button : this.buttons) {
            button.getButton().func_146118_a(mouseX, mouseY);
        }
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        boolean ret = false;
        for (IModuleConfigButton<?> btn : this.buttons) {
            ret |= btn.keyTyped(typedChar, keyCode);
        }
        return ret;
    }

    private final class TextHolder {
        private final IModule module;
        private final int x;
        private final int y;
        private final int height;

        TextHolder(IModule module, int x, int y) {
            this.module = module;
            this.x = x;
            this.y = y;
            this.height = (module.getSummary().size() + 1) * ModuleConfigButtonManager.this.lineHeight;
        }

        public IModule getModule() {
            return this.module;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextHolder)) {
                return false;
            }
            TextHolder other = (TextHolder)o;
            IModule this$module = this.getModule();
            IModule other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            if (this.getX() != other.getX()) {
                return false;
            }
            if (this.getY() != other.getY()) {
                return false;
            }
            return this.getHeight() == other.getHeight();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IModule $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            result = result * 59 + this.getX();
            result = result * 59 + this.getY();
            result = result * 59 + this.getHeight();
            return result;
        }

        public String toString() {
            return "ModuleConfigButtonManager.TextHolder(module=" + this.getModule() + ", x=" + this.getX() + ", y=" + this.getY() + ", height=" + this.getHeight() + ")";
        }
    }
}

