/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.IModuleConfig;
import net.gegy1000.psf.server.block.remote.GuiRemoteControl;
import net.gegy1000.psf.server.block.remote.GuiSelectModule;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.block.remote.TileRemoteControlSystem;
import net.gegy1000.psf.server.block.remote.config.IModuleConfigButton;
import net.gegy1000.psf.server.block.remote.config.ModuleConfigButtonManager;
import net.gegy1000.psf.server.block.remote.config.PacketConfigChange;
import net.gegy1000.psf.server.network.PSFNetworkHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiModuleConfig
extends GuiRemoteControl {
    private final GuiSelectModule parent;
    private final int craftIndex;
    private final List<IModule> moduleGroup;
    private ModuleConfigButtonManager buttonManager;
    private List<IModuleConfigButton<?>> buttons = new ArrayList();

    public GuiModuleConfig(GuiSelectModule parent, int craftIndex, List<IModule> moduleGroup, TileRemoteControlSystem te) {
        super((GuiScreen)parent, te);
        this.parent = parent;
        this.craftIndex = craftIndex;
        this.moduleGroup = moduleGroup;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonManager = new ModuleConfigButtonManager(this, this.field_147003_i + 10, this.field_147009_r + 10, this.field_146999_f - 20, this.field_147000_g - 20);
        this.func_189646_b(this.buttonManager);
        for (IModule module : this.moduleGroup) {
            this.buttonManager.addSummary(module);
            for (IModuleConfig cfg : module.getConfigs()) {
                this.buttonManager.create(module, cfg);
            }
            this.buttonManager.spacer(4);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.buttonManager.keyTyped(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scroll = Mouse.getEventDWheel();
        this.buttonManager.scroll(scroll);
    }

    @Override
    @Nullable
    protected IListedSpacecraft getCraft() {
        return this.getTe().getCrafts().get(this.craftIndex);
    }

    @Override
    public void updateModule(UUID id, NBTTagCompound tag) {
        for (IModule m : this.moduleGroup) {
            if (!m.getId().equals(id)) continue;
            m.readUpdateTag(tag);
        }
    }

    void updateConfig(IModule module, IModuleConfig cfg) {
        PSFNetworkHandler.network.sendToServer((IMessage)new PacketConfigChange(this.getTe().getCrafts().get(this.craftIndex), module, cfg));
    }
}

