/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.api.IUnique;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

@ParametersAreNonnullByDefault
public class TileRemoteControlSystem
extends TileEntity {
    private Map<UUID, IListedSpacecraft> crafts = new HashMap<UUID, IListedSpacecraft>();

    private Collector<IListedSpacecraft, ?, Map<UUID, IListedSpacecraft>> toMap() {
        return Collectors.toMap(IUnique::getId, Functions.identity());
    }

    public void rebuildCraftList() {
        if (!this.func_145831_w().field_72995_K) {
            this.crafts = PracticalSpaceFireworks.PROXY.getSatellites().getAll().stream().map(ISatellite::toListedCraft).collect(this.toMap());
        }
    }

    public void provideServerCrafts(List<IListedSpacecraft> crafts) {
        this.crafts = crafts.stream().collect(this.toMap());
    }

    public void provideSingleCraft(IListedSpacecraft craft) {
        this.crafts.put(craft.getId(), craft);
    }

    public List<IListedSpacecraft> getCrafts() {
        return Lists.newArrayList(this.crafts.values());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return super.func_189515_b(compound);
    }
}

