/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.data.IScannedChunk;
import net.gegy1000.psf.api.data.ITerrainScan;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MapRenderer
extends Gui {
    private static final VertexFormat POSITION_COLOR_NORMAL = new VertexFormat();
    private static final EnumFacing[] RENDER_FACES;
    private final ITerrainScan terrainScan;
    private final List<ChunkRenderer> chunkRenderers;
    private final ExecutorService chunkBuildService = Executors.newSingleThreadExecutor();

    public MapRenderer(ITerrainScan terrainScan) {
        this.terrainScan = terrainScan;
        ArrayList<IScannedChunk> chunks = new ArrayList<IScannedChunk>(terrainScan.getChunks());
        chunks.sort(Comparator.comparingInt(value -> {
            ChunkPos chunkPos = value.getChunkPos();
            return chunkPos.field_77276_a * chunkPos.field_77276_a + chunkPos.field_77275_b * chunkPos.field_77275_b;
        }));
        this.chunkRenderers = chunks.stream().map(x$0 -> new ChunkRenderer((IScannedChunk)x$0)).collect(Collectors.toList());
    }

    public void performUploads() {
        this.chunkRenderers.forEach(rec$ -> ((ChunkRenderer)rec$).performUploads());
    }

    public void render() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-this.terrainScan.getMaxHeight()), (float)0.0f);
        this.chunkRenderers.forEach(rec$ -> ((ChunkRenderer)rec$).render());
        GlStateManager.func_179121_F();
    }

    public void delete() {
        this.chunkBuildService.shutdownNow();
        this.chunkRenderers.forEach(rec$ -> ((ChunkRenderer)rec$).delete());
    }

    protected void finalize() throws Throwable {
        this.delete();
        super.finalize();
    }

    public boolean shouldUpdate(ITerrainScan scan) {
        return !scan.equals(this.terrainScan);
    }

    public ITerrainScan getTerrainScan() {
        return this.terrainScan;
    }

    static {
        POSITION_COLOR_NORMAL.func_181721_a(DefaultVertexFormats.field_181713_m);
        POSITION_COLOR_NORMAL.func_181721_a(DefaultVertexFormats.field_181714_n);
        POSITION_COLOR_NORMAL.func_181721_a(DefaultVertexFormats.field_181717_q);
        POSITION_COLOR_NORMAL.func_181721_a(DefaultVertexFormats.field_181718_r);
        RENDER_FACES = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};
    }

    private class ChunkRenderer {
        private final IScannedChunk scannedChunk;
        private final int globalX;
        private final int globalZ;
        private Future<BufferBuilder> builtMesh;
        private int displayList = -1;

        private ChunkRenderer(IScannedChunk scannedChunk) {
            this.scannedChunk = scannedChunk;
            this.globalX = scannedChunk.getChunkPos().func_180334_c();
            this.globalZ = scannedChunk.getChunkPos().func_180333_d();
            this.builtMesh = MapRenderer.this.chunkBuildService.submit(() -> {
                BufferBuilder builder = new BufferBuilder(32768);
                this.buildMesh(builder);
                return builder;
            });
        }

        private void performUploads() {
            if (this.builtMesh != null && this.builtMesh.isDone()) {
                try {
                    BufferBuilder builder = this.builtMesh.get();
                    if (builder != null) {
                        int id = GLAllocation.func_74526_a((int)1);
                        builder.func_178977_d();
                        GlStateManager.func_187423_f((int)id, (int)4864);
                        new WorldVertexBufferUploader().func_181679_a(builder);
                        GlStateManager.func_187415_K();
                        this.displayList = id;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    PracticalSpaceFireworks.LOGGER.error("Failed to retrieve built chunk mesh", (Throwable)e);
                }
                this.builtMesh = null;
            }
        }

        private void render() {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.globalX, (float)0.0f, (float)this.globalZ);
            if (this.displayList != -1) {
                GlStateManager.func_179148_o((int)this.displayList);
            } else {
                GlStateManager.func_179131_c((float)0.4f, (float)0.6f, (float)0.8f, (float)1.0f);
                GlStateManager.func_179140_f();
                for (int i = 0; i < 4; ++i) {
                    this.drawGrid(16, 16 >> i);
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179145_e();
            }
            GlStateManager.func_179121_F();
        }

        private void drawGrid(int size, int blockSize) {
            int blockCount = size / blockSize;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            builder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            for (int x = 0; x <= blockCount; ++x) {
                int lineX = x * blockSize;
                builder.func_181662_b((double)lineX, 62.0, 0.0).func_181675_d();
                builder.func_181662_b((double)lineX, 62.0, (double)size).func_181675_d();
            }
            for (int z = 0; z <= blockCount; ++z) {
                int lineZ = z * blockSize;
                builder.func_181662_b(0.0, 62.0, (double)lineZ).func_181675_d();
                builder.func_181662_b((double)size, 62.0, (double)lineZ).func_181675_d();
            }
            tessellator.func_78381_a();
        }

        private void delete() {
            if (this.displayList != -1) {
                GLAllocation.func_74523_b((int)this.displayList);
            }
        }

        private void buildMesh(BufferBuilder builder) {
            builder.func_181668_a(7, POSITION_COLOR_NORMAL);
            IScannedChunk scannedChunk = this.scannedChunk;
            for (BlockPos pos : BlockPos.func_191531_b((int)0, (int)0, (int)0, (int)15, (int)255, (int)15)) {
                List faces;
                MapColor mapColor = scannedChunk.getMapColor(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                if (mapColor == null || (faces = Arrays.stream(RENDER_FACES).filter(face -> {
                    BlockPos offset = pos.func_177972_a(face);
                    return this.getMapColor(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p()) == null;
                }).collect(Collectors.toList())).isEmpty()) continue;
                int color = mapColor.field_76291_p;
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color & 0xFF;
                builder.func_178969_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                for (EnumFacing face2 : faces) {
                    this.buildFace(builder, face2, red, green, blue);
                }
            }
            builder.func_178969_c(0.0, 0.0, 0.0);
        }

        private MapColor getMapColor(int x, int y, int z) {
            if (x < 0 || y < 0 || z < 0 || x >= 16 || y >= 256 || z >= 16) {
                return MapRenderer.this.terrainScan.getMapColor(x + this.globalX, y, z + this.globalZ);
            }
            return this.scannedChunk.getMapColor(x, y, z);
        }

        private void buildFace(BufferBuilder builder, EnumFacing facing, int red, int green, int blue) {
            switch (facing) {
                case NORTH: {
                    builder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    builder.func_181662_b(0.0, 1.0, 0.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    builder.func_181662_b(1.0, 1.0, 0.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    builder.func_181662_b(1.0, 0.0, 0.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    break;
                }
                case SOUTH: {
                    builder.func_181662_b(0.0, 0.0, 1.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                    builder.func_181662_b(1.0, 0.0, 1.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                    builder.func_181662_b(1.0, 1.0, 1.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                    builder.func_181662_b(0.0, 1.0, 1.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                    break;
                }
                case WEST: {
                    builder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(red, green, blue, 255).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    builder.func_181662_b(0.0, 0.0, 1.0).func_181669_b(red, green, blue, 255).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    builder.func_181662_b(0.0, 1.0, 1.0).func_181669_b(red, green, blue, 255).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    builder.func_181662_b(0.0, 1.0, 0.0).func_181669_b(red, green, blue, 255).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    break;
                }
                case EAST: {
                    builder.func_181662_b(1.0, 1.0, 0.0).func_181669_b(red, green, blue, 255).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    builder.func_181662_b(1.0, 1.0, 1.0).func_181669_b(red, green, blue, 255).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    builder.func_181662_b(1.0, 0.0, 1.0).func_181669_b(red, green, blue, 255).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    builder.func_181662_b(1.0, 0.0, 0.0).func_181669_b(red, green, blue, 255).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    break;
                }
                case UP: {
                    builder.func_181662_b(0.0, 1.0, 1.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    builder.func_181662_b(1.0, 1.0, 1.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    builder.func_181662_b(1.0, 1.0, 0.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    builder.func_181662_b(0.0, 1.0, 0.0).func_181669_b(red, green, blue, 255).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                }
            }
        }
    }
}

