/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote;

import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.client.IVisualReceiver;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.block.remote.TileRemoteControlSystem;
import net.gegy1000.psf.server.block.remote.packet.PacketTrackCraft;
import net.gegy1000.psf.server.network.PSFNetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class GuiRemoteControl
extends GuiContainer
implements IVisualReceiver {
    @Nonnull
    protected static final ResourceLocation TEXTURE_LOC = new ResourceLocation("psf", "textures/gui/control_system.png");
    @Nullable
    private final GuiScreen parent;
    private final TileRemoteControlSystem te;

    protected GuiRemoteControl(@Nullable GuiScreen parent, final TileRemoteControlSystem te) {
        super(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
                if (te.func_145831_w().func_175625_s(te.func_174877_v()) != te) {
                    return false;
                }
                return playerIn.func_70092_e((double)te.func_174877_v().func_177958_n() + 0.5, (double)te.func_174877_v().func_177956_o() + 0.5, (double)te.func_174877_v().func_177952_p() + 0.5) <= 64.0;
            }
        });
        this.parent = parent;
        this.te = te;
        this.field_146999_f = 256;
        this.field_147000_g = 201;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        IListedSpacecraft craft = this.getCraft();
        if (craft != null) {
            PSFNetworkHandler.network.sendToServer((IMessage)new PacketTrackCraft(craft.getId(), true));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        GuiScreen parent = this.getParent();
        if (parent != null && mouseButton == 1) {
            Minecraft.func_71410_x().func_147108_a(parent);
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_LOC);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void setVisual(IVisualReceiver.IVisual visual) {
    }

    @Override
    public void updateModule(UUID id, NBTTagCompound tag) {
    }

    @Override
    public void updateCraft(@Nonnull IListedSpacecraft craft) {
        this.te.provideSingleCraft(craft);
    }

    @Nullable
    protected IListedSpacecraft getCraft() {
        return null;
    }

    protected void untrack() {
        IListedSpacecraft craft = this.getCraft();
        if (craft != null) {
            PSFNetworkHandler.network.sendToServer((IMessage)new PacketTrackCraft(craft.getId(), false));
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.untrack();
    }

    @Nullable
    public GuiScreen getParent() {
        return this.parent;
    }

    public TileRemoteControlSystem getTe() {
        return this.te;
    }
}

