/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.server.block.remote.AbstractScrollingList;
import net.gegy1000.psf.server.block.remote.GuiSelectModule;
import net.minecraft.client.Minecraft;

@ParametersAreNonnullByDefault
public class GuiModuleList
extends AbstractScrollingList<List<IModule>> {
    private final GuiSelectModule parent;

    private static List<List<IModule>> groupModules(List<IModule> modules) {
        modules = Lists.newArrayList(modules);
        ArrayList<List<IModule>> ret = new ArrayList<List<IModule>>();
        while (!modules.isEmpty()) {
            ArrayList<IModule> bucket = new ArrayList<IModule>();
            IModule identity = (IModule)modules.remove(0);
            bucket.add(identity);
            for (IModule m : modules) {
                if (!identity.groupWith(m)) continue;
                bucket.add(m);
            }
            modules.removeAll(bucket);
            ret.add(bucket);
        }
        ret.sort(Comparator.comparing(list -> ((IModule)list.get(0)).getLocalizedName()));
        return ret;
    }

    public GuiModuleList(GuiSelectModule parent, List<IModule> modules, Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight, int screenWidth, int screenHeight) {
        super(GuiModuleList.groupModules(modules), client, width, height, top, bottom, left, entryHeight, screenWidth, screenHeight);
        this.parent = parent;
    }

    @Override
    @Nonnull
    protected String getText(List<IModule> element) {
        String title = element.get(0).getLocalizedName();
        if (element.size() > 1) {
            title = title + " (x" + element.size() + ")";
        }
        return title;
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.parent.selectModuleGroup((List)this.getElement(index));
    }
}

