/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.remote;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.data.ITerrainScan;
import net.gegy1000.psf.client.IVisualReceiver;
import net.gegy1000.psf.client.render.spacecraft.model.SpacecraftModel;
import net.gegy1000.psf.server.block.remote.GuiRemoteControl;
import net.gegy1000.psf.server.block.remote.GuiSelectCraft;
import net.gegy1000.psf.server.block.remote.GuiSelectModule;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.block.remote.MapRenderer;
import net.gegy1000.psf.server.block.remote.TileRemoteControlSystem;
import net.gegy1000.psf.server.capability.CapabilityModuleData;
import net.gegy1000.psf.server.entity.spacecraft.LaunchMetadata;
import net.gegy1000.psf.server.fluid.PSFFluidRegistry;
import net.gegy1000.psf.server.modules.data.EmptyTerrainScan;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.Rectangle;

public class GuiCraftDetails
extends GuiRemoteControl {
    @Nonnull
    private static final ResourceLocation PREVIEW_BG = new ResourceLocation("psf", "textures/gui/preview_bg.png");
    private static final boolean scissorAvailable = GLContext.getCapabilities().OpenGL20;
    private final int selectedCraft;
    private PreviewMode mode = PreviewMode.CRAFT;
    private GuiButton buttonModules;
    private GuiButton buttonBack;
    private GuiButton buttonMode;
    private GuiButton buttonLaunch;
    private GuiTextField tfName;
    private final Rectangle panel;
    @Nullable
    private SyncedData synced;
    @Nonnull
    private Map<Fluid, ResourceAmount> fluidData = new HashMap<Fluid, ResourceAmount>();
    private MapRenderer mapRenderer;

    protected GuiCraftDetails(GuiSelectCraft parent, int selected, TileRemoteControlSystem te) {
        super((GuiScreen)parent, te);
        this.selectedCraft = selected;
        this.field_146999_f = 256;
        this.field_147000_g = 201;
        this.panel = new Rectangle(10, 10, this.field_146999_f / 2 - 20, this.field_147000_g - 20);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        IListedSpacecraft craft = this.getCraft();
        if (craft != null && this.synced == null) {
            craft.requestVisualData();
        }
        this.buttonModules = new GuiButtonExt(-1, this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 34, 115, 20, "Modules");
        this.func_189646_b(this.buttonModules);
        this.buttonBack = new GuiButtonExt(0, this.field_147003_i + this.field_146999_f - 50 - 10, this.field_147009_r + this.field_147000_g - 20 - 10, 50, 20, "Back");
        this.func_189646_b(this.buttonBack);
        this.buttonMode = new GuiButtonExt(1, this.field_147003_i + this.panel.getX() + this.panel.getWidth() - 22, this.field_147009_r + this.panel.getY() + 2, 20, 20, "C");
        this.func_189646_b(this.buttonMode);
        this.buttonLaunch = new GuiButtonExt(2, this.field_147003_i + this.panel.getX() + this.panel.getWidth() + 10, this.field_147009_r + this.field_147000_g - 20 - 10, 50, 20, "Launch");
        this.func_189646_b(this.buttonLaunch);
        this.tfName = new GuiTextField(99, this.field_146297_k.field_71466_p, this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 10, 115, 20);
        if (craft != null) {
            this.tfName.func_146180_a(craft.getName());
            this.buttonLaunch.field_146125_m = craft.canLaunch();
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        SyncedData synced = this.synced;
        if (synced != null) {
            List tanks = synced.tankModules.stream().map(m -> (IFluidHandler)m.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).filter(Objects::nonNull).flatMap(handler -> Arrays.stream(handler.getTankProperties())).collect(Collectors.toList());
            HashMap<Fluid, ResourceAmount> totalFluid = new HashMap<Fluid, ResourceAmount>();
            for (IFluidTankProperties tank : tanks) {
                FluidStack contents = tank.getContents();
                if (contents == null) continue;
                ResourceAmount amount = totalFluid.computeIfAbsent(contents.getFluid(), fluid -> new ResourceAmount());
                amount.add(contents.amount, tank.getCapacity());
            }
            this.fluidData = totalFluid;
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.tfName != null) {
            this.tfName.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.tfName != null && this.tfName.func_146201_a(typedChar, keyCode)) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        if (this.selectedCraft >= 0) {
            this.updateName();
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.delete();
        }
    }

    private void updateName() {
        IListedSpacecraft craft = this.getCraft();
        if (craft != null) {
            craft.setName(this.tfName.func_146179_b());
        }
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        IListedSpacecraft craft = this.getCraft();
        if (button == this.buttonModules && this.synced != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectModule(this, this.selectedCraft, this.synced.modules, this.getTe()));
        } else if (button == this.buttonBack) {
            this.updateName();
            this.untrack();
            this.field_146297_k.func_147108_a(this.getParent());
        } else if (button == this.buttonMode) {
            this.mode = PreviewMode.values()[(this.mode.ordinal() + 1) % PreviewMode.values().length];
            this.buttonMode.field_146126_j = this.mode.name().substring(0, 1);
        } else if (button == this.buttonLaunch && craft != null) {
            craft.launch();
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        IListedSpacecraft craft = this.getCraft();
        this.drawBackground(craft);
        if (craft != null && this.synced != null) {
            this.renderPreview(this.synced);
            this.tfName.func_146194_f();
            this.drawStats(this.synced, craft);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        IListedSpacecraft craft = this.getCraft();
        SyncedData synced = this.synced;
        if (craft != null && !craft.isOrbiting() && synced != null) {
            ResourceAmount lox;
            LaunchMetadata metadata = synced.metadata;
            int x = this.panel.getX() + 4;
            int y = this.panel.getY() + this.panel.getHeight() - 4;
            int width = this.panel.getWidth() - 8;
            if (metadata.getThrusters().isEmpty()) {
                y -= this.drawWarning(x, y, width, Collections.singletonList("No Thrusters!"), mouseX, mouseY);
            } else if (metadata.getTotalForce() / metadata.getMass() < 2.0) {
                y -= this.drawWarning(x, y, width, Collections.singletonList("Low Thrust!"), mouseX, mouseY);
            }
            ResourceAmount kerosene = this.fluidData.get(PSFFluidRegistry.KEROSENE);
            if (kerosene != null && (float)kerosene.amount / (float)kerosene.capacity < 0.25f) {
                y -= this.drawWarning(x, y, width, Collections.singletonList("Low Kerosene!"), mouseX, mouseY);
            }
            if ((lox = this.fluidData.get(PSFFluidRegistry.LIQUID_OXYGEN)) != null && (float)lox.amount / (float)lox.capacity < 0.25f) {
                y -= this.drawWarning(x, y, width, Collections.singletonList("Low LOX!"), mouseX, mouseY);
            }
        }
    }

    private int drawWarning(int x, int y, int width, List<String> strings, int mx, int my) {
        GlStateManager.func_179147_l();
        int height = strings.size() * (this.field_146297_k.field_71466_p.field_78288_b + 2) + 6;
        int alpha = ((mx -= this.field_147003_i) >= x && (my -= this.field_147009_r) <= y && mx <= x + width && my >= y - height ? 85 : 255) << 24;
        GuiCraftDetails.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y - height), (int)(alpha | 0x333333));
        GuiCraftDetails.func_73734_a((int)(x + 1), (int)(y - 1), (int)(x + width - 1), (int)(y - height + 1), (int)(alpha | 0xC1AD00));
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_LOC);
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(alpha >>> 24) / 255.0f));
        this.func_73729_b(x + 3, y - (int)Math.ceil((float)height / 2.0f) - 4, 115, 202, 9, 9);
        int sy = y - height + 5;
        for (String s : strings) {
            this.field_146297_k.field_71466_p.func_78276_b(s, x + 15, sy, alpha | 0x333333);
            sy += this.field_146297_k.field_71466_p.field_78288_b + 2;
        }
        return height + 2;
    }

    private void drawBackground(@Nullable IListedSpacecraft craft) {
        GuiCraftDetails.func_73734_a((int)(this.field_147003_i + this.panel.getX() - 1), (int)(this.field_147009_r + this.panel.getY() - 1), (int)(this.field_147003_i + this.panel.getX() + this.panel.getWidth() + 1), (int)(this.field_147009_r + this.panel.getY() + this.panel.getHeight() + 1), (int)-7697782);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(PREVIEW_BG);
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        int craftY = craft == null ? 0 : craft.getPosition().func_177956_o();
        float alpha = 0.0f;
        if (craftY > 256) {
            alpha = Math.min((float)(craftY - 256) / 500.0f, 1.0f);
        }
        this.func_73729_b(this.field_147003_i + this.panel.getX(), this.field_147009_r + this.panel.getY(), 0, 0, this.panel.getWidth(), this.panel.getHeight());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.func_73729_b(this.field_147003_i + this.panel.getX(), this.field_147009_r + this.panel.getY(), 128, 0, this.panel.getWidth(), this.panel.getHeight());
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179084_k();
    }

    private void renderPreview(SyncedData synced) {
        switch (this.mode) {
            case CRAFT: {
                this.renderCraft(synced.model);
                break;
            }
            case MAP: {
                this.renderMap(synced);
            }
        }
    }

    private void renderMap(SyncedData syncedData) {
        Optional<ITerrainScan> terrainScan = syncedData.terrainScannerModules.stream().map(module -> module.getCapability(CapabilityModuleData.TERRAIN_SCAN, null)).filter(Objects::nonNull).findFirst();
        ITerrainScan buildScan = terrainScan.orElseGet(() -> new EmptyTerrainScan(2));
        if (this.mapRenderer == null || this.mapRenderer.shouldUpdate(buildScan)) {
            if (this.mapRenderer != null) {
                this.mapRenderer.delete();
            }
            this.mapRenderer = new MapRenderer(buildScan);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        if (scissorAvailable) {
            ScaledResolution sr = new ScaledResolution(this.field_146297_k);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((this.field_147003_i + this.panel.getX()) * sr.func_78325_e()), (int)(this.field_146297_k.field_71440_d - (this.field_147009_r + this.panel.getY() + this.panel.getHeight()) * sr.func_78325_e()), (int)(this.panel.getWidth() * sr.func_78325_e()), (int)(this.panel.getHeight() * sr.func_78325_e()));
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(this.field_147003_i + this.field_146999_f / 4), (float)(this.field_147009_r + this.field_147000_g / 2), (float)500.0f);
        GlStateManager.func_179114_b((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_74520_c();
        GlStateManager.func_179114_b((float)((float)this.field_146297_k.field_71439_g.field_70173_aa + this.field_146297_k.func_184121_ak()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)-1.8, (double)-1.8, (double)-1.8);
        GlStateManager.func_179137_b((double)-8.0, (double)0.0, (double)-8.0);
        this.mapRenderer.performUploads();
        this.mapRenderer.render();
        if (scissorAvailable) {
            GL11.glDisable((int)3089);
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179101_C();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
    }

    private void renderCraft(SpacecraftModel model) {
        BlockPos from = model.getRenderWorld().getMinPos();
        BlockPos to = model.getRenderWorld().getMaxPos();
        AxisAlignedBB bb = new AxisAlignedBB(new Vec3d((Vec3i)from), new Vec3d((Vec3i)to).func_72441_c(1.0, 1.0, 1.0));
        GlStateManager.func_179094_E();
        double lengthX = (bb.field_72336_d - bb.field_72340_a) * 16.0;
        double lengthY = (bb.field_72337_e - bb.field_72338_b) * 16.0;
        double lengthZ = (bb.field_72334_f - bb.field_72339_c) * 16.0;
        double halfX = lengthX / 2.0;
        double halfY = lengthY / 2.0;
        double halfZ = lengthZ / 2.0;
        double maxW = 96.0;
        double maxH = 176.0;
        double overW = Math.max(lengthX - 96.0, lengthZ - 96.0);
        double overH = lengthY - 176.0;
        double sc = 1.0;
        if (overW > 0.0 && overW >= overH) {
            sc = 96.0 / (overW + 96.0);
        } else if (overH > 0.0 && overH >= overW) {
            sc = 176.0 / (overH + 176.0);
        }
        GlStateManager.func_179137_b((double)((double)this.field_147003_i + (halfX *= sc) + (double)(this.field_146999_f / 4)), (double)((double)this.field_147009_r + (halfY *= sc) + (double)(this.field_147000_g / 2)), (double)500.0);
        BlockPos min = model.getRenderWorld().getMinPos();
        GlStateManager.func_179137_b((double)(-halfX), (double)(-halfY), (double)(-(halfZ *= sc)));
        GlStateManager.func_179114_b((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.field_146297_k.field_71439_g.field_70173_aa + this.field_146297_k.func_184121_ak()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)halfX, (double)halfY, (double)halfZ);
        GlStateManager.func_179139_a((double)sc, (double)sc, (double)sc);
        GlStateManager.func_179109_b((float)(min.func_177958_n() * 16), (float)(min.func_177956_o() * 16), (float)(min.func_177952_p() * 16));
        GlStateManager.func_179152_a((float)-16.0f, (float)-16.0f, (float)-16.0f);
        if (scissorAvailable) {
            ScaledResolution sr = new ScaledResolution(this.field_146297_k);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((this.field_147003_i + this.panel.getX()) * sr.func_78325_e()), (int)(this.field_146297_k.field_71440_d - (this.field_147009_r + this.panel.getY() + this.panel.getHeight()) * sr.func_78325_e()), (int)(this.panel.getWidth() * sr.func_78325_e()), (int)(this.panel.getHeight() * sr.func_78325_e()));
        }
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        model.render(BlockRenderLayer.SOLID);
        GlStateManager.func_179141_d();
        model.render(BlockRenderLayer.CUTOUT_MIPPED);
        this.field_146297_k.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        model.render(BlockRenderLayer.CUTOUT);
        this.field_146297_k.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179147_l();
        model.render(BlockRenderLayer.TRANSLUCENT);
        GlStateManager.func_179084_k();
        if (scissorAvailable) {
            GL11.glDisable((int)3089);
        }
        GlStateManager.func_179121_F();
    }

    private void drawStats(SyncedData synced, IListedSpacecraft craft) {
        int x = this.field_147003_i + this.field_146999_f / 2;
        int y = this.field_147009_r + 62;
        int color = -13421773;
        boolean orbiting = craft.isOrbiting();
        if (orbiting) {
            ResourceAmount amount = new ResourceAmount();
            synced.modules.stream().filter(m -> m.hasCapability(CapabilityEnergy.ENERGY, null)).map(m -> (IEnergyStorage)m.getCapability(CapabilityEnergy.ENERGY, null)).forEach(storage -> amount.add(storage.getEnergyStored(), storage.getMaxEnergyStored()));
            this.field_146297_k.field_71466_p.func_78276_b("Energy", x, y, color);
            this.drawBar(x, y += 12, amount.amount, amount.capacity, -12977);
            y += 12;
        } else {
            for (Map.Entry entry : this.fluidData.entrySet()) {
                String localizedName = I18n.func_135052_a((String)((Fluid)entry.getKey()).getUnlocalizedName(), (Object[])new Object[0]);
                this.field_146297_k.field_71466_p.func_78276_b(localizedName, x, y, color);
                this.drawBar(x, y += 12, ((ResourceAmount)entry.getValue()).amount, ((ResourceAmount)entry.getValue()).capacity, ((Fluid)entry.getKey()).getColor());
                y += 12;
            }
        }
        this.field_146297_k.field_71466_p.func_78276_b(orbiting ? "Orbiting Over:" : "Position:", x, y, color);
        BlockPos pos = craft.getPosition();
        this.field_146297_k.field_71466_p.func_78276_b("X: " + pos.func_177958_n(), x += 5, y += 10, color);
        if (!orbiting) {
            this.field_146297_k.field_71466_p.func_78276_b("Y: " + pos.func_177956_o(), x, y += 10, color);
        }
        this.field_146297_k.field_71466_p.func_78276_b("Z: " + pos.func_177952_p(), x, y += 10, color);
        LaunchMetadata launchMetadata = synced.metadata;
        this.field_146297_k.field_71466_p.func_78276_b("Mass: " + DecimalFormat.getInstance().format(launchMetadata.getMass()) + "kg", x -= 5, y += 15, color);
    }

    private void drawBar(int x, int y, int value, int max, int color) {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_LOC);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        float valueScale = (float)value / (float)max;
        this.func_73729_b(x, y, 0, 202, 115, 5);
        GlStateManager.func_179131_c((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)1.0f);
        this.func_73729_b(x, y, 0, 207, (int)(valueScale * 115.0f), 5);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    @Nullable
    public IListedSpacecraft getCraft() {
        if (this.selectedCraft >= 0) {
            return this.getTe().getCrafts().get(this.selectedCraft);
        }
        return null;
    }

    @Override
    public void setVisual(@Nonnull IVisualReceiver.IVisual visual) {
        this.synced = new SyncedData(visual);
    }

    @Override
    public void updateModule(@Nonnull UUID id, @Nonnull NBTTagCompound tag) {
        if (this.synced != null) {
            this.synced.modules.stream().filter(m -> m.getId().equals(id)).findFirst().ifPresent(m -> m.readUpdateTag(tag));
        }
    }

    private class ResourceAmount {
        private int capacity;
        private int amount;

        private ResourceAmount() {
        }

        public void add(int amount, int capacity) {
            this.amount += amount;
            this.capacity += capacity;
        }
    }

    private class SyncedData {
        final Collection<IModule> modules;
        final Collection<IModule> terrainScannerModules;
        final Collection<IModule> tankModules;
        final SpacecraftModel model;
        final LaunchMetadata metadata;

        public SyncedData(IVisualReceiver.IVisual visual) {
            this.model = SpacecraftModel.build(visual.getBlockAccess());
            this.modules = visual.getModules();
            this.terrainScannerModules = this.modules.stream().filter(module -> module.hasCapability(CapabilityModuleData.TERRAIN_SCAN, null)).collect(Collectors.toList());
            this.tankModules = this.modules.stream().filter(m -> m.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).collect(Collectors.toList());
            this.metadata = visual.getBlockAccess().buildLaunchMetadata();
        }
    }

    static enum PreviewMode {
        CRAFT,
        MAP;

    }
}

