/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.module;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.IModuleFactory;
import net.gegy1000.psf.server.capability.CapabilityModule;
import net.gegy1000.psf.server.modules.Modules;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public class TileModule
extends TileEntity {
    @Nullable
    private IModule module;

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        IModule module = this.getModule();
        return super.hasCapability(capability, facing) || module != null && module.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        IModule module = this.getModule();
        if (module != null && module.hasCapability(capability, facing)) {
            return module.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        IModule module = this.module;
        if (module != null) {
            ResourceLocation moduleID = module.getRegistryName();
            Preconditions.checkNotNull((Object)moduleID, (Object)"Module does not have registry name set!");
            compound.func_74778_a("moduleID", moduleID.toString());
            compound.func_74782_a("moduleData", module.serializeNBT());
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("moduleID")) {
            String id = Strings.emptyToNull((String)compound.func_74779_i("moduleID"));
            Preconditions.checkNotNull((Object)id, (Object)"No module data found!");
            IModuleFactory factory = (IModuleFactory)Modules.get().getValue(new ResourceLocation(id));
            Preconditions.checkNotNull((Object)factory, (Object)"Unknown module type!");
            this.module = (IModule)factory.get();
            this.module.deserializeNBT((NBTBase)compound.func_74775_l("moduleData"));
        }
    }

    @Nullable
    public static IModule getModule(TileEntity entity) {
        if (entity != null && entity.hasCapability(CapabilityModule.INSTANCE, null)) {
            return (IModule)entity.getCapability(CapabilityModule.INSTANCE, null);
        }
        return null;
    }

    public TileModule() {
    }

    public TileModule(@Nullable IModule module) {
        this.module = module;
    }

    @Nullable
    public IModule getModule() {
        return this.module;
    }
}

