/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.module;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.IModuleFactory;
import net.gegy1000.psf.server.api.RegisterItemBlock;
import net.gegy1000.psf.server.api.RegisterItemModel;
import net.gegy1000.psf.server.block.controller.BlockController;
import net.gegy1000.psf.server.block.module.TileModule;
import net.gegy1000.psf.server.modules.Modules;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockModule
extends Block
implements RegisterItemBlock,
RegisterItemModel {
    public static final ThreadLocal<Boolean> CONVERTING = ThreadLocal.withInitial(() -> false);
    @Nonnull
    public static final IProperty<EnumFacing> DIRECTION = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    private final ResourceLocation moduleID;
    private IModuleFactory factory;

    public BlockModule(Material mat, @Nonnull String module) {
        super(mat);
        this.moduleID = new ResourceLocation("psf", module);
        this.func_149647_a(PracticalSpaceFireworks.TAB);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    protected IModule createModule(@Nonnull World world, @Nonnull IBlockState state) {
        IModuleFactory factory = this.factory;
        if (factory == null) {
            factory = (IModuleFactory)Modules.get().getValue(this.moduleID);
            if (factory == null) {
                throw new IllegalStateException("Could not find module for ID: " + this.moduleID);
            }
            this.factory = factory;
        }
        return (IModule)factory.get();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIRECTION});
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected boolean canAttachOnSide(IBlockState state, IBlockState on, EnumFacing side) {
        return true;
    }

    public boolean func_176198_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        BlockPos pos2 = pos.func_177972_a(side.func_176734_d());
        IBlockState on = world.func_180495_p(pos2).func_185899_b((IBlockAccess)world, pos2);
        if (!this.canAttachOnSide(this.func_176223_P().func_177226_a(DIRECTION, (Comparable)side), on, side)) {
            return false;
        }
        if (this.isStructuralModule(null, this.func_176223_P())) {
            return this.func_176196_c(world, pos);
        }
        return BlockModule.isStructural(this.func_176223_P(), on) && super.func_176198_a(world, pos, side);
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a(DIRECTION, (Comparable)facing);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState other;
        BlockPos connectedTo;
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        if (!this.isStructuralModule(null, state) && (connectedTo = pos.func_177972_a(((EnumFacing)state.func_177229_b(DIRECTION)).func_176734_d())).equals((Object)fromPos) && !BlockModule.isStructural(state, other = worldIn.func_180495_p(connectedTo).func_185899_b((IBlockAccess)worldIn, connectedTo))) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileModule(this.createModule(world, state));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((EnumFacing)state.func_177229_b(DIRECTION)).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        meta = Math.abs(meta & 7) % EnumFacing.values().length;
        return this.func_176223_P().func_177226_a(DIRECTION, (Comparable)EnumFacing.values()[meta]);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a(DIRECTION, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b(DIRECTION)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_177226_a(DIRECTION, (Comparable)mirror.func_185803_b((EnumFacing)state.func_177229_b(DIRECTION)));
    }

    public boolean isStructuralModule(@Nullable IBlockState connecting, IBlockState state) {
        return false;
    }

    public static boolean isStructural(@Nullable IBlockState connecting, IBlockState state) {
        return state.func_177230_c() instanceof BlockController || state.func_177230_c() instanceof BlockModule && ((BlockModule)state.func_177230_c()).isStructuralModule(connecting, state);
    }
}

