/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.module;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.server.block.module.BlockModule;
import net.gegy1000.psf.server.block.module.TileModule;
import net.gegy1000.psf.server.modules.ModuleFuelTank;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFuelTank
extends BlockModule {
    private static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    private static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    private static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    private static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public BlockFuelTank() {
        super(Material.field_151573_f, "fuel_tank");
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(3.0f);
        this.func_149647_a(PracticalSpaceFireworks.TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIRECTION, NORTH, SOUTH, WEST, EAST});
    }

    @Override
    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        BlockPos neighbourPos = pos.func_177972_a(side);
        IBlockState neighbour = blockAccess.func_180495_p(neighbourPos);
        neighbour = neighbour.func_185899_b(blockAccess, neighbourPos);
        if (side.func_176740_k() == EnumFacing.Axis.Y && neighbour.func_177230_c() == this) {
            int count = 0;
            if (((Boolean)neighbour.func_177229_b((IProperty)NORTH)).booleanValue()) {
                ++count;
            }
            if (((Boolean)neighbour.func_177229_b((IProperty)SOUTH)).booleanValue()) {
                ++count;
            }
            if (((Boolean)neighbour.func_177229_b((IProperty)EAST)).booleanValue()) {
                ++count;
            }
            if (((Boolean)neighbour.func_177229_b((IProperty)WEST)).booleanValue()) {
                ++count;
            }
            if (count == 2) {
                return true;
            }
        }
        return !this.canConnect(state, blockAccess, pos, side) || neighbour.func_177230_c() != this;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnect(state, world, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(state, world, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnect(state, world, pos, EnumFacing.EAST))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnect(state, world, pos, EnumFacing.WEST)));
    }

    private boolean canConnect(IBlockState me, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos.func_177972_a(side));
        return state.func_177230_c() == this || BlockModule.isStructural(me, state);
    }

    @Override
    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (!((Boolean)CONVERTING.get()).booleanValue()) {
            this.updateNeighbors(state, worldIn, pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        IModule module;
        if (placer instanceof EntityPlayer && ((EntityPlayer)placer).field_71075_bZ.field_75098_d && (module = TileModule.getModule(world.func_175625_s(pos))) instanceof ModuleFuelTank) {
            ((ModuleFuelTank)module).setFull();
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!((Boolean)CONVERTING.get()).booleanValue()) {
            this.updateNeighbors(state, worldIn, pos);
        }
    }

    private void updateNeighbors(IBlockState state, World worldIn, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            if (!this.canConnect(state, (IBlockAccess)worldIn, pos, dir)) continue;
            BlockPos pos2 = pos.func_177972_a(dir);
            worldIn.func_175685_c(pos2, worldIn.func_180495_p(pos2).func_177230_c(), true);
        }
    }

    @Override
    public int func_176201_c(@Nonnull IBlockState state) {
        return 0;
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Override
    public boolean isStructuralModule(@Nullable IBlockState connecting, IBlockState state) {
        if (connecting != null && connecting.func_177230_c() == this) {
            return true;
        }
        if (connecting == null) {
            return true;
        }
        boolean n = (Boolean)state.func_177229_b((IProperty)NORTH);
        boolean s = (Boolean)state.func_177229_b((IProperty)SOUTH);
        boolean w = (Boolean)state.func_177229_b((IProperty)WEST);
        boolean e = (Boolean)state.func_177229_b((IProperty)EAST);
        if (n && e) {
            return w || s;
        }
        if (n && w) {
            return e || s;
        }
        if (s && e) {
            return n || w;
        }
        if (s && w) {
            return n || e;
        }
        return true;
    }
}

